<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_DisplayItem 
	extends W3B_Controller 
{
	const MODELNAME_ITEM = 'theModelItem' ;
	const MODELNAME_COMMENTS = 'MODELNAME_COMMENTS' ;
	const MODELNAME_ATTACHMENTS = 'MODELNAME_ATTACHMENTS' ;
	
	const VIEWNAME_ITEM = 'theViewItem' ;
	const VIEWNAME_COMMENTFORM = 'VIEWNAME_COMMENTFORM' ;
	const VIEWNAME_COMMENTS = 'VIEWNAME_COMMENTS' ;
	
	const CTLRNAME_CATEGORY = 'theControllerCategory' ;
	const CTLRNAME_POSTCOMMENT = 'CTLRNAME_POSTCOMMENT' ;
	

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_DisplayItem(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
	
		// set item type
		$aRequest = $this->GetRequest() ;
		$sType = $aRequest->GetParam('type') ;
		if( !$sType )
		{
			$sType = Ext_JCCMS::CATEGORY_TYPE_ARTICLE ;
			$aRequest->SetParam('type',$sType) ;
		}
		
		// mvc
		$aService = $this->GetService() ;
		
		// create model and view
		$aModel = new Ext_JCCMS_ModelItem($aService,true) ;
		$this->AddModel($aModel,self::MODELNAME_ITEM) ;
		
		$aModelAttachments = new Ext_JCCMS_AggModelAttachment($aService) ;
		$this->AddModel($aModelAttachments,self::MODELNAME_ATTACHMENTS) ;
		
		$aModelComments = new Ext_JCCMS_AggModelComment(true) ;
		$aModelComments->SetCountPerPage(10) ;
		$this->AddModel($aModelComments,self::MODELNAME_COMMENTS) ;
		
		$aViewComments = new Ext_JCCMS_ViewCommentList($this) ;
		$aViewComments->SetModel($aModelComments) ;
		$this->AddView($aViewComments,self::VIEWNAME_COMMENTS) ;
		

		$aView = new JCAT_ViewHtml('template.Ext_JCCMS_ViewItem.html',$this,'Ext_JCCMS_ViewItem') ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEWNAME_ITEM) ;
		
		// child controller
		$aCategoryPath = W3B_Controller::CreateController('Ext_JCCMS_CategoryPath',$aService) ;
		$aCategoryPath->SetViewContainer($aView) ;
		$this->AddController($aCategoryPath,self::CTLRNAME_CATEGORY) ;
		
		// 
		$aPostComment = W3B_Controller::CreateController('Ext_JCCMS_PostComment',$aService) ;
		$this->AddController($aPostComment,self::CTLRNAME_POSTCOMMENT) ;
		
		$aView = $aPostComment->GetView(Ext_JCCMS_PostComment::VIEW_COMMENTFORM) ;
		$this->AddView($aView,self::VIEWNAME_COMMENTFORM) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aView = $this->GetView(self::VIEWNAME_ITEM) ;
		
		do{
			$aRequest = $this->GetRequest() ;
			$nItemId = $aRequest->GetParam('nItemId') ;
			if( !is_numeric($nItemId) or $nItemId<1 )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nItemId ，或参数无效。','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
				$aView = new JCAT_ViewHtmlMessageQueue($this) ;
				break ;
			}

			$aModel = $this->GetModel(self::MODELNAME_ITEM) ;


			// 载入文档
			$aModel->FindBy('bPublic','1') ;
			$aModel->FindById($nItemId) ;
			if( !$aModel->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的文档不存在(id:%s).','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
				$aView = new JCAT_ViewHtmlMessageQueue($this) ;
				break ;
			}
			
			
			// 执行子控制器
			// -------------
			$aCtlrCategory = $this->GetController(self::CTLRNAME_CATEGORY) ;			
			
			// 设置分类
			$nCategoryId = $aModel->Get('nCategoryId') ;
			$aRequest = $aCtlrCategory->GetRequest() ;
			$aRequest->SetParam('category',$nCategoryId) ;
			
			// 设置 view container
			$aCtlrCategory->SetViewContainer($aView) ;
			
			// 执行
			$aCtlrCategory->MainRun() ;
			
			// 发表评论
			$aCtlrPostComment = $this->GetController(self::CTLRNAME_POSTCOMMENT) ;
			$aCtlrPostComment->MainRun() ;
			
			
			// 载入评论
			$aModelComments = $this->GetModel(self::MODELNAME_COMMENTS) ;
			$aModelComments->FindBy('nReplyTo',$nItemId) ;
			$aModelComments->Load() ;
						
			// 载入附件
			$aModelAttachments = $this->GetModel(self::MODELNAME_ATTACHMENTS) ;
			$aModelAttachments->FindBy('nItemId',$nItemId) ;
			$aModelAttachments->Load() ;
			
			// 更新浏览次数
			// -------------
			$aModel->Set('nView',$aModel->Get('nView')+1) ;
			$aModel->Save() ;
		
		} while(0) ;
		
		$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		$aFrame->RenderFrame($aView) ;
	}

}

?>