<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_DisplayItemList 
	extends W3B_Controller 
{
	const MODELNAME_LIST = 'theModelList' ;
	const MODELNAME_CATEGORY = 'theModelCategory' ;
	const VIEWNAME_LIST = 'theViewList' ;
	const CTLRNAME_CATEGORY = 'theControllerCategory' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_DisplayItemList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{		
		// set item type
		$aRequest = $this->GetRequest() ;
		$sType = $aRequest->GetParam('type') ;
		if( !$sType )
		{
			$sType = Ext_JCCMS::CATEGORY_TYPE_ARTICLE ;
			$aRequest->SetParam('type',$sType) ;
		}
		
		$aService = $this->GetService() ;
		
		// create model
		$aModel = new Ext_JCCMS_AggModelItem($aService,true) ;
		$this->AddModel($aModel,self::MODELNAME_LIST) ;
	
		// create view
		$sTemplate = $aRequest->GetParam('template') ;
		if(!$sTemplate) 
		{
			$sTemplate = 'template.Ext_JCCMS_ViewItemList.html' ;
		}
		$aView = new Ext_JCCMS_ViewItemList($sTemplate,$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEWNAME_LIST) ;
		$sPagination = $aRequest->GetParam('pagination') ;
		$aView->SetViewVar('bDisplayPagination',($sPagination===null or $sPagination=='1')) ;
		
		// child controller
		$aCategoryPath = W3B_Controller::CreateController('Ext_JCCMS_CategoryPath',$aService) ;
		$aCategoryPath->SetViewContainer($aView) ;
		$this->AddController($aCategoryPath,self::CTLRNAME_CATEGORY) ;
		
		// limit
		$nCount = $aRequest->GetParam('count') ;
		if($nCount) 
		{
			$aModel->SetCountPerPage(intval($nCount)) ;
		}
		
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$nStartTime = microtime(true) ; 
		$aService = $this->GetService() ;
		
		$aModel = $this->GetModel(self::MODELNAME_LIST) ;
		$aView = $this->GetView(self::VIEWNAME_LIST) ;
		$aCtlrCategory = $this->GetController(self::CTLRNAME_CATEGORY) ;
		
		// 执行子控制器
		$aCtlrCategory->MainRun();
		
		// 设置分类
		list($nLft,$Rgt) = $aCtlrCategory->GetCategoryBorder() ;
		$aModel->FindByCondition("(Ext_JCCMS_Category.nLft>={$nLft} and Ext_JCCMS_Category.nRgt<={$Rgt})") ;
		
		// 载入文档
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('文档遇到错误.','Ext_JCCMS',null),MSGMVC_BAD) ;
		}
		
		$aConn = $aModel->GetORM()->GetDB()->GetConnect() ;
		$aConn->GetLastSQL() ;		
		$aView->SetViewVar('nQueryTime',$aConn->GetQueryTime()) ;
		$aView->SetViewVar('nLoadTime',microtime(true)-$nStartTime) ;
		
		$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		$aFrame->RenderFrame($aView) ;
	}
}

?>