<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_HandOverItem 
 *
 * @access public
 */
class Ext_JCCMS_HandOverItem 
	extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_HandOverItem(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}
	
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('所属用户变更','Ext_JCCMS',null)
		) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aFrame,'Ext_JCHtmlFrame_IController' );
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		// action
		$aRequest = $this->GetRequest() ;
		do{
			$nItemId=$aRequest->GetParam('nItemId') ;
			$nUserId=$aRequest->GetParam('nUserId') ;

			if(!$nItemId or !$nUserId)
			{
				break ;				
			}
			
			$aItem = new Ext_JCCMS_ModelItem($aService) ;
			$aItem->FindBy('nItemId',$nItemId) ;
			if( !$aItem->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的项目不存在(nItemId:%s)','Ext_JCCMS',null,$nItemId),MSGMVC_BAD) ;
				break ;
			}
			
			$aUser = new Ext_JCUser_Model() ;
			$aUser->FindBy('nUserId',$nUserId) ;
			if( !$aUser->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的用户不存在(nUserId:%s)','Ext_JCCMS',null,$nUserId),MSGMVC_BAD) ;
				break ;
			}
			
			$aItem->Set('nUserId',$nUserId) ;
			if( $aItem->Save() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('项目已经转移给了用户：%s','Ext_JCCMS',null,$aUser->Get('sUserName')),MSGMVC_OK) ;
			}
			
			else
			{
				new JCAT_Message(JCAT_Language::SentenceEx('操作失败','Ext_JCCMS',null),MSGMVC_BAD) ;
			}
			
		} while(0) ;
		
		$aView = new JCAT_ViewHtml('template.Ext_JCCMS_ViewHandOverItem.html',$this) ; 
		$aFrame->RenderFrame($aView) ;
	}

}

?>