<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_ItemListPad 
	extends W3B_Controller 
{
	const MODELNAME_LIST = 'theModelList' ;
	const VIEWNAME_LIST = 'theViewList' ;

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{		
		$aService = $this->GetService() ;
		$aRequest = $this->GetRequest() ;
		
		// create model
		$aModel = new Ext_JCCMS_AggModelItem($aService,true) ;
		$this->AddModel($aModel,self::MODELNAME_LIST) ;
	
		// limit
		$nCount = $aRequest->GetParam('count') ;
		if($nCount) 
		{
			$aModel->SetCountPerPage(intval($nCount)) ;
		}
		
		// create view
		$sTemplate = $aRequest->GetParam('template') ;
		if(!$sTemplate) 
		{
			$sTemplate = 'template.Ext_JCCMS_ViewItemListPad.html' ;
		}
		$aView = new Ext_JCCMS_ViewItemList($sTemplate,$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEWNAME_LIST) ;
		$sPagination = $aRequest->GetParam('pagination') ;
		$aView->SetViewVar('bDisplayPagination',($sPagination===null or $sPagination=='1')) ;
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		//$aService = $this->GetService() ;
		$aRequest = $this->GetRequest() ;
		
		$aModel = $this->GetModel(self::MODELNAME_LIST) ;
		$aView = $this->GetView(self::VIEWNAME_LIST) ;

		// 载入分类
		$nLft = $aRequest->GetParam('lft') ;
		if( !is_numeric($nLft) or $nLft<1 )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'缺少参数 lft, 或参数无效', 'Ext_JCCMS', null
			)) ;
		}
		$nRgt = $aRequest->GetParam('rgt') ;
		if( !is_numeric($nRgt) or $nRgt<1 )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'缺少参数 rgt, 或参数无效', 'Ext_JCCMS', null
			)) ;
		}
		
		$sTitle = $aRequest->GetParam('title') ;
		
		// 设置分类
		$aModel->FindByCondition("(Ext_JCCMS_Category.nLft>={$nLft} and Ext_JCCMS_Category.nRgt<={$nRgt})") ;
		
		// 载入文档
		if( !$aModel->Load() )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'文档错误。', 'Ext_JCCMS', null
			)) ;
		}
		
		// 推荐星级
		$nStar = $aRequest->GetParam('star') ;
		if($nStar>=0)
		{
			$aModel->FindBy('nStar',$nStar) ;
		}
		
		// 排列
		$nSort = $aRequest->GetParam('sort') ;
		if($nSort)
		{
			$aModel->SortBy($nSort) ;
		}
		

		// 将视图提供给布局框架
		$aViewDecorator = new JCAT_ViewHtmlLayoutDecorator($sTitle,$aView) ;
		$aCSSTheme = $aViewDecorator->GetCSSTheme() ;
		$aCSSTheme->SetUsingTheme('Ext_JCCMS_ItemListPad') ;
		$aCSSTheme->DefineFile('Ext_JCCMS_ItemListPad.css',$aViewDecorator->GetUI()) ;
		
		$aFrame = $this->GetViewContainer() ;
		$aFrame->AddView($aViewDecorator) ;
	}
}

?>