<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 Ext_JCCMS_PostDoc 
 *
 * @access public
 */
class Ext_JCCMS_ModelAttachment extends JCAT_DBModel
{    
	const PROP_USER_RC_DIR = 'PROP_USER_RC_DIR' ;
	static private $arrORMConf_Base = array(
		'hub' => array(
			'table' => 'Ext_JCCMS_Attachments'
			, 'primaryKey' => 'nAId'
		)
	) ;

	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCCMS_ModelAttachment(W3B_Service $aService,JCAT_DB $aDB=null)
	{
		$this->JCAT_DBModel( self::CreateShareORM($aDB) ) ;
		
		$aExtension = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCCMS') ;
		if ( !$aExtension )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展尚未载入：Ext_JCCMS', 'Ext_JCCMS', null
			)) ;
		}
		$this->Set(self::PROP_USER_RC_DIR,$aExtension->GetDefaultUserRCDirectory(false)) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetUrl()
	{
		$sStorePath = $this->Get('sStorePath') ;
		if( $sStorePath )
		{
			$sFullPath = $this->Get(self::PROP_USER_RC_DIR).$sStorePath ;
			if(is_file($sFullPath))
			{
				return JCAT_DownloadFile::GetHTTPAccessPath($sFullPath) ;
			}
		}
		else
		{
			return null ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ORM
	 */
	static public function CreateShareORM(JCAT_DB $aDB=null)
	{
		if( !isset(self::$arrShareORM['base']) )
		{
			self::$arrShareORM['base'] = new JCAT_ORM($aDB) ;
			self::$arrShareORM['base']->InitFromConfig(self::$arrORMConf_Base) ;
		}

		return self::$arrShareORM['base'] ;
	}
	
	/**
	 * 删除模型
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Delete()
	{
		// 删除主图片
		$sFilename = $this->Get('sStorePath') ;
		if( $sFilename )
		{
			$sFilePath = $this->Get(self::PROP_USER_RC_DIR)."/{$sFilename}" ;
			unlink($sFilePath) ;
			if( !is_file($sFilePath) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('文件：%s 已经删除(存储文件名：%s)。','Ext_JCCMS',null,$this->Get('sOriFilename'),$sFilename),MSGMVC_OK) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('文件：%s 删除失败(存储文件名：%s)。','Ext_JCCMS',null,$this->Get('sOriFilename'),$sFilename),MSGMVC_BAD) ;
			}
		}
		
		return parent::Delete() ;
	}

	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrShareORM = array() ;
}

?>