<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 Ext_JCCMS_PostDoc 
 *
 * @access public
 */
class Ext_JCCMS_ModelItem extends JCAT_DBModel
{
    const PROP_CATEGORY = 'category' ;
    
    const PROP_USER = 'user' ;
    
    const PROP_SERVICEID = 'nServiceId' ;
    
    const PROP_USER_RC_DIR = 'sUserRCDirectory' ;
    
	static private $arrORMConf_Base = array(
		'hub' => array(
			'table' => 'Ext_JCCMS_Item'
			, 'primaryKey' => 'nItemId'
		)
	) ;
	
	static private $arrORMConf_Full = array(
		
		'belongsTo' => array(
			
			array(
				'table' => 'Ext_JCCMS_Category'
				, 'foreignKeyFrom' => 'nCategoryId'
				, 'foreignKeyTo' => 'nCategoryId'
				, 'property' => self::PROP_CATEGORY
			)
			
			, array(
				'table' => 'Ext_JCUser'
				, 'foreignKeyFrom' => 'nUserId'
				, 'foreignKeyTo' => 'nUserId'
				, 'property' => self::PROP_USER
			)
			
		)	
	) ;

	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCCMS_ModelItem(W3B_Service $aService,$bFull=false,JCAT_DB $aDB=null)
	{
		$this->JCAT_DBModel( self::CreateShareORM($bFull,$aDB) ) ;
		
		$this->AutoDecodeHtml(false) ;
		
		$nServiceId = $aService->GetServiceId() ;
		$this->Set(self::PROP_SERVICEID,$nServiceId) ;
		if($nServiceId)
		{
			$this->FindBy('nServiceId',$nServiceId) ;
		}
		
		$aExtension = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCCMS') ;
		if ( !$aExtension )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展尚未载入：Ext_JCCMS', 'Ext_JCCMS', null
			)) ;
		}
		$this->Set('sUserRCDirectory',$aExtension->GetDefaultUserRCDirectory()) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function HasPhoto()
	{
		return $this->Get('sPhoto')? true: false ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetPhotoUrl()
	{
		$sPhoto = $this->Get('sPhoto') ;
		if( $sPhoto )
		{
			$sPhotoPath = $this->Get('sUserRCDirectory').$sPhoto ;
			if(is_file($sPhotoPath))
			{
				return JCAT_DownloadFile::GetHTTPAccessPath($sPhotoPath) ;
			}
		}
		else
		{
			return null ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ORM
	 */
	static public function CreateShareORM($bFull=false,JCAT_DB $aDB=null)
	{
		$sORMConfName = $bFull? 'full': 'base' ;
		$arrORMConf = self::$arrORMConf_Base ;
		if($bFull)
		{
			$arrORMConf = array_merge($arrORMConf,self::$arrORMConf_Full) ;
		}
		
		if( !isset(self::$arrShareORM[$sORMConfName]) )
		{
			self::$arrShareORM[$sORMConfName] = new JCAT_ORM($aDB) ;
			self::$arrShareORM[$sORMConfName]->InitFromConfig($arrORMConf) ;
		}

		return self::$arrShareORM[$sORMConfName] ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	Ext_JCCMS_ModelCategory
	 */
	public function GetCategory()
	{
		
	}
	
	/**
	 * 删除模型
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Delete()
	{
		// 删除主图片
		$sFilename = $this->Get('sPhoto') ;
		if( $sFilename )
		{
			$sFilePath = $this->Get(self::PROP_USER_RC_DIR)."/{$sFilename}" ;
			unlink($sFilePath) ;
			if( !is_file($sFilePath) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('图片：%s已经删除。','Ext_JCCMS',null,$sFilename),MSGMVC_OK) ;
			}
			
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('图片：%s 删除失败。','Ext_JCCMS',null,$sFilename),MSGMVC_OK) ;
			}
		}
		
		return parent::Delete() ;
	}

	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrShareORM = array() ;
}

?>