<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_PostAdminList 
 *
 * @access public
 */
class Ext_JCCMS_PostComment 
	extends W3B_Controller 
{
	const MODEL_COMMENT = 'MODEL_COMMENT' ;
	const VIEW_COMMENTFORM = 'VIEW_COMMENTFORM' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_PostComment(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
	
		
		// create model and view
		$aModel = new Ext_JCCMS_ModelComment() ;
		$this->AddModel($aModel,self::MODEL_COMMENT) ;

		$aView = new JCAT_ViewHtmlForm('template.Ext_JCCMS_ViewCommentForm.html',$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_COMMENTFORM) ;
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsPosting()
	{
		$aRequest = $this->GetRequest() ;
		return $aRequest->GetParam('bPostComment')? true: false ;		
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aRequest = $this->GetRequest() ;
		if(!$this->IsPosting())
		{
			return ;
		}
		
		$nItemId = intval($aRequest->GetParam('nItemId')) ;
		if(!$nItemId)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nItemId，或参数无效。','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;			
		}
		$aModel = $this->GetModel(self::MODEL_COMMENT) ;
		$aService = $this->GetService() ;

		$sComment = $aRequest->GetParam('sComment') ;
		$sComment = trim($sComment) ;
		if(!$sComment)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('请输入评论内容。','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;			
		}
		
		$sComment = htmlspecialchars($sComment) ;
		$sComment = nl2br($sComment) ;
		$aModel->Set('sDetail',$sComment) ;
		$aModel->Set('nCreateTime',time()) ;
		$aModel->Set('nReplyTo',$nItemId) ;
		$aModel->Set('nServiceId',$aService->GetServiceId()) ;
		$aModel->Set('sTitle',$_SERVER['REMOTE_ADDR']) ;
		
		if( $aModel->Create() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('评论发布成功。','Ext_JCCMS',null),MSGMVC_OK) ;
			
			// 更新 items 表中的冗余
			$aDB = $this->GetService()->GetPlatform()->GetDefaultDB() ;
			$nComment = $aDB->GetCount('Ext_JCCMS_Item',"nReplyTo={$nItemId}") ;
			$aDB->Update('Ext_JCCMS_Item',array('nComment'=>$nComment),"nItemId={$nItemId}") ;
			return ;	
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('评论发布遇到错误，请联系管理员。','Ext_JCCMS',null),MSGMVC_BAD) ;
			return ;	
		}
	}

}

?>