<?php
/**
 * 扩展：Ext_JCCMS
 * 
 * @access	public
 */
class Ext_JCCMS extends W3B_Extension
{
    const CATEGORY_TYPE = 'EXTDATA:CATEGORY_TYPE' ;
    const CATEGORY_TYPE_ARTICLE = "ARTICLE" ;
    
	const EVENT_NAMESPACE = "\\Ext\\JCCMS" ;
	const EVENT_CATEGORY_SHOWOPERATIONS = 'OnShowCategoryOperations' ;
	const EVENT_ITEM_SHOWOPERATIONS = 'OnShowItemOperations' ;
    
    
	/**
	 * 取得扩展名称
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionName()
	{
		return 'Ext_JCCMS' ;
	}

	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('JeCat 内容管理系统','Ext_JCCMS',$sLanguage) ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('由 JeCat 团队提供的内容管理系统。','Ext_JCCMS',$sLanguage) ;
	}

	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function GetVersion()
	{
		return new JCAT_Version(0,1,0,0,'') ;
	}
	
	/**
	 * 取得扩展的兼容版本号
	 * 扩展自此版本以来，接口未发生任何变化，依赖此版本的其它扩展，可在当前版本上正常工作。
	 *
	 * @access	public
	 * @static 
	 * @return	void
	 */
	static public function GetCompatibleVersion()
	{
		return self::GetVersion() ;
	}
	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		$theEventDispatcher->RegisterHandle(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array(__CLASS__,'SetupAdminFrameMenu') , array()
				, Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
		
		// 定义事件
		// ------------------
		// 显示分类的操作
		$theEventDispatcher->DefineEvent(self::EVENT_CATEGORY_SHOWOPERATIONS,self::EVENT_NAMESPACE
				, JCAT_Language::SentenceEx('显示分类的操作','Ext_JCCMS',null)
				, array('Ext_JCCMS_ModelCategory','string') );
		// 显示文章的操作
		$theEventDispatcher->DefineEvent(self::EVENT_ITEM_SHOWOPERATIONS,self::EVENT_NAMESPACE
				, JCAT_Language::SentenceEx('显示文章的操作','Ext_JCCMS',null)
				, array('Ext_JCCMS_ModelItem') );
	}
	
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		parent::Load($aService) ;
		
		// 注册其他控制器
		W3B_Platform::RegisterHTTPPublicController('Ext_JCCMS_DisplayItem') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCCMS_DisplayItemList') ;
		
		// 注册 post 类型
		$this->RegisterData(
				self::CATEGORY_TYPE
				, JCAT_Language::SentenceEx('文章','Ext_JCCMS',null)
				, self::CATEGORY_TYPE_ARTICLE ) ;
	}

	/**
	 * 配置 管理框架 菜单
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetupAdminFrameMenu(JCAT_IUICtrlHtmlMenu $theFrameMenu)
	{		
		$sMenuXML = '<Menu>
	<MenuItem text="开始" package="Ext_JCCMS" link="/?controller=Ext_JCHtmlFrame_AdminWelcome" />
	<MenuItem text="信息" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminItemList">
		<MenuItem text="文章系统" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminItemList">
			<MenuItem text="新建文章" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminItem" />
			<MenuItem text="文章管理" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminItemList" />
			<MenuItem text="新建文章分类" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminCategory" />
			<MenuItem text="文章分类管理" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminCategoryList" />
			<MenuItem text="所属用户变更" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_HandOverItem" />
		</MenuItem>
		<MenuItem text="用户评论管理" package="Ext_JCCMS" link="/?controller=Ext_JCCMS_AdminCommentList" />
	</MenuItem>
</Menu>' ;

		$theFrameMenu->BuildMenuFromXML($sMenuXML,false) ;
	}

}

?>