<?php

class Ext_JCCMS_Setup extends W3B_ExtensionDefaultSetup 
{
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetResourceDBTables()
	{
		$arrDBTables['Ext_JCCMS_Category'] = "CREATE TABLE IF NOT EXISTS `Ext_JCCMS_Category` (
  `nCategoryId` int(8) NOT NULL auto_increment,
  `nServiceId` int(8) NOT NULL default '0',
  `nLft` int(9) NOT NULL,
  `nRgt` int(9) NOT NULL,
  `nDepth` int(2) NOT NULL default '-1',
  `sName` varchar(240) character set gbk NOT NULL,
  `sDescription` text,
  `sPictrue` varchar(240) NOT NULL default '',
  `bEnable` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`nCategoryId`),
  KEY `nLft` (`nLft`),
  KEY `nRgt` (`nRgt`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		$arrDBTables['Ext_JCCMS_Item'] = "CREATE TABLE IF NOT EXISTS `Ext_JCCMS_Item` (
  `nItemId` int(11) NOT NULL auto_increment,
  `nServiceId` int(8) NOT NULL default '0',
  `nCategoryId` int(8) NOT NULL default '0',
  `sTitle` varchar(120) NOT NULL,
  `sPhoto` varchar(80) NOT NULL default '',
  `sDetail` text,
  `nCreateTime` int(10) NOT NULL default '0',
  `nModifyTime` int(10) NOT NULL default '0',
  `nUserId` int(10) NOT NULL default '0',
  `nReplyTo` int(11) NOT NULL default '0',
  `bPublic` enum('0','1') NOT NULL default '1',
  `nView` int(10) NOT NULL default '0',
  `nComment` int(10) NOT NULL default '0',
  `nStar` tinyint(1) NOT NULL default '0',
  `nPriority` int(2) NOT NULL default '40',
  PRIMARY KEY  (`nItemId`),
  KEY `nCreateTime` (`nCreateTime`),
  KEY `nUserId` (`nUserId`),
  KEY `nReplyTo` (`nReplyTo`),
  KEY `nPriority` (`nPriority`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		$arrDBTables['Ext_JCCMS_Attachments'] = "CREATE TABLE IF NOT EXISTS `Ext_JCCMS_Attachments` (
  `nAId` int(10) NOT NULL auto_increment,
  `nServiceId` int(8) NOT NULL,
  `nItemId` int(11) NOT NULL,
  `sStorePath` varchar(120) NOT NULL,
  `sOriFilename` varchar(120) NOT NULL,
  `sName` varchar(120) NOT NULL,
  `sDescription` text NOT NULL,
  `nUploaderId` int(11) NOT NULL,
  `nUploadTime` int(10) NOT NULL,
  PRIMARY KEY  (`nAId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;" ;
		
		return $arrDBTables ;
	}

	/**
	 * 回收资源
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Service
	 * @return	void
	 */
	public function ClearServiceResource(W3B_Service $aService) 
	{
		$this->ClearSrvRCBySrvId($aService) ;
	}
	
	
}

?>
