JCAT.Class.CheckDependClasses(['JCAT.MVC.UICtrl'],'Ext_JCCMS_CategoryLinkedMenu') ;

function Ext_JCCMS_CategoryLinkedMenu(sName,sID,sUIName)
{
	this._wndDiv = document.getElementById(sID) ;
	if(!this._wndDiv)
	{
		throw "the div(id:"+sID+") is not exists." ;
	}

	// 默认选项
	//this._bDisplayDefaultOption = true
	this._sDefaultOptionText = null ;
	this._sDefaultOptionValue = '-1' ;
	
	// 创建 下拉菜单
	this._wndInput = document.createElement('input') ;
	this._wndInput.type = 'hidden' ;
	this._wndInput.name = sName ;
	this._wndInput.value = this._sDefaultOptionValue ;
	this._wndDiv.appendChild(this._wndInput) ;

	// 父类的构造函数
	this.UICtrlConstruct(sName,sID,sUIName) ;
	this.IFormConstruct() ;
	
	// 第一层菜单
	this._aTopMenu = new Ext_JCCMS_CategoryLinkedMenu.Menu(this,0) ;
	
	// 活动菜单
	this._aActiveMenu = this._aTopMenu ;
}

//继承
JCAT.Class.Inherit(Ext_JCCMS_CategoryLinkedMenu,JCAT.MVC.UICtrl) ;

//实现 IForm 接口
JCAT.Class.Inherit(Ext_JCCMS_CategoryLinkedMenu,JCAT.MVC.UICtrl.IForm,'IFormConstruct') ;


Ext_JCCMS_CategoryLinkedMenu.prototype.GetTopMenu = function()
{
	return this._aTopMenu ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.GetMenu = function(nLevel)
{
	sId = Ext_JCCMS_CategoryLinkedMenu.Menu.MakeSelectId(this,nLevel)
	wndSel = document.getElementById(sId)
	if(!wndSel||!wndSel.instance)
	{
		return null ;
	}
	
	return wndSel.instance ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.GetWnd = function()
{
	return this._wndDiv ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.DisplayDefaultOption = function(bDisplay)
{
	this._bDisplayDefaultOption = bDisplay ;
}
Ext_JCCMS_CategoryLinkedMenu.prototype.IsDisplayDefaultOption = function()
{
	return (this._sDefaultOptionText!=null) ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.SetDefaultOptionText = function(sText)
{
	this._sDefaultOptionText = sText ;
}
Ext_JCCMS_CategoryLinkedMenu.prototype.GetDefaultOptionText = function()
{
	return this._sDefaultOptionText ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.SetDefaultOptionValue = function(sValue)
{
	this._sDefaultOptionValue = sValue ;
}
Ext_JCCMS_CategoryLinkedMenu.prototype.GetDefaultOptionValue = function()
{
	return this._sDefaultOptionValue ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.GetActiveMenu = function ()
{
	aActiveMenu = this._aTopMenu
	
	while( aNextMenu=aActiveMenu.GetNextMenu() )
	{
		aActiveMenu = aNextMenu ;
	}
	
	return aActiveMenu ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.SetInput = function (sValue)
{
	this._wndInput.value = sValue ;
}

// 实现 IForm 接口
Ext_JCCMS_CategoryLinkedMenu.prototype.SetData = function (sValue)
{
	this.SetInput(sValue) ;
}

Ext_JCCMS_CategoryLinkedMenu.prototype.GetData = function ()
{
	return this.GetActiveMenu().GetValue()
}

Ext_JCCMS_CategoryLinkedMenu.prototype.GetDataLength = function ()
{
	return this.GetActiveMenu().GetSelected()
}


//////////////////////

Ext_JCCMS_CategoryLinkedMenu.Menu = function(aUICtrl,nLevel)
{
	this._aUICtrl = aUICtrl ;
	this._nLevel = nLevel ;
	
	// 创建 下拉菜单
	this._wndSel = document.createElement('select') ;
	this._wndSel.instance = this ;
	// this._wndSel.name = Ext_JCCMS_CategoryLinkedMenu.Menu.MakeSelectName(aUICtrl,nLevel)
	this._wndSel.id = Ext_JCCMS_CategoryLinkedMenu.Menu.MakeSelectId(aUICtrl,nLevel)
	divUICtrl = aUICtrl.GetWnd() ;
	divUICtrl.appendChild(this._wndSel) ;
	this._wndSel.onchange = function (){this.instance.OnMenuChange() ;}
	
	//
	this._nextMenu = null ;
}

//静态方法：产生select id
Ext_JCCMS_CategoryLinkedMenu.Menu.MakeSelectId = function(aUICtrl,nLevel)
{
	return aUICtrl.GetName()+'_Lv'+nLevel ;
}

//静态方法：产生select name
Ext_JCCMS_CategoryLinkedMenu.Menu.MakeSelectName = function(aUICtrl,nLevel)
{
	return aUICtrl.GetName()+'Sel[]'
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.GetLevel = function ()
{
	return this._nLevel ;
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.GetNextMenu = function ()
{
	return this._nextMenu ;
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.Destroy = function ()
{
	// 先销毁下级菜单
	if(this._nextMenu)
	{
		this._nextMenu.Destroy() ;
	}
	
	// 删除 select 
	this._aUICtrl.GetWnd().removeChild(this._wndSel)
	this._wndSel = null
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.CreateNextMenu = function ()
{
	if(this._nextMenu)
	{
		return this._nextMenu ;
	}

	this._nextMenu = new Ext_JCCMS_CategoryLinkedMenu.Menu(this._aUICtrl,this.GetLevel()+1) ;
	return this._nextMenu ;
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.GetWnd = function ()
{
	return this._wndSel ;
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.OnMenuChange = function ()
{
	// 销毁原有下级菜单
	if(this._nextMenu)
	{
		this._nextMenu.Destroy()
		this._nextMenu = null
	}
	
	// 创建新的下级菜单
	if(this._wndSel.options.selectedIndex<0)
	{
		return ;
	}

	// 将自己菜单里选择的内容 传递给控件
	sValue = this._wndSel.options[this._wndSel.options.selectedIndex].value ;
	if(sValue!=this._aUICtrl.GetDefaultOptionValue())
	{
		this._aUICtrl.SetInput(sValue)
	}
	
	// 将上级菜单中的
	else
	{
		aParentMenu = this._aUICtrl.GetMenu(this._nLevel-1) ;
		if(aParentMenu)
		{
			this._aUICtrl.SetInput(aParentMenu.GetWnd().value)
		}
	}
	
	aChildItem = this._wndSel.options[this._wndSel.options.selectedIndex].instance
	// 没有下级内容
	if( !aChildItem || aChildItem.GetChildrenCount()<=0 )
	{
		return ;
	}

	// 创建 并加载下级内容
	else
	{
		aNextMenu = this.CreateNextMenu() ;
		aNextMenu.ClearOptions() ;
		aNextMenu.LinkToItem(aChildItem) ;
	}

}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.ClearOptions = function()
{
	for(var i=this._wndSel.options.length-1;i>=0;i--)
	{
		this._wndSel.options[i] = null ;
	}
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.LinkToItem = function(aItem)
{
	// 创建默认菜单
	if(this._aUICtrl.IsDisplayDefaultOption())
	{
		wndOption = new Option(this._nLevel?'继续选择':this._aUICtrl.GetDefaultOptionText(),this._aUICtrl.GetDefaultOptionValue()) ;
		this._wndSel.options.add(wndOption) ;
	}
	
	// 加载菜单
	for(i=0;i<aItem.GetChildrenCount();i++)
	{
		aChildItem = aItem.GetChild(i) ;

		wndOption = new Option(aChildItem.GetText(),aChildItem.GetValue()) ;
		this._wndSel.options.add(wndOption) ;
		wndOption.instance = aChildItem ;
	}
	
	this.OnMenuChange() ;
}


Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.SetSelected = function (nSelIdx)
{
	if(this._wndSel.options.selectedIndex!=nSelIdx)
	{
		this._wndSel.options.selectedIndex = nSelIdx ;
		this.OnMenuChange() ;
	}
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.GetSelected = function ()
{
	if(this._wndSel.options.selectedIndex>=0)
	{
		return this._wndSel.options.selectedIndex ;
	}
	
	else
	{
		return -1 ;
	}
}

Ext_JCCMS_CategoryLinkedMenu.Menu.prototype.GetValue = function ()
{
	if(this._wndSel.options.selectedIndex>=0)
	{
		return this._wndSel.options[this._wndSel.options.selectedIndex].value ;
	}
	
	else
	{
		return null ;
	}
}
//////////////////////

Ext_JCCMS_CategoryLinkedMenu.MenuItem = function(sText,sValue)
{
	this._sText = sText ;
	this._sValue = sValue ;
	this._arrChildren = new Array() ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.GetText = function ()
{
	return this._sText ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.GetValue = function ()
{
	return this._sValue ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.AddChild = function (aChildItem)
{
	this._arrChildren.push(aChildItem) ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.ClearChildren = function ()
{
	this._arrChildren = new Array() ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.GetChild = function (nIdx)
{
	if(nIdx>=this._arrChildren.length)
	{
		throw "Ext_JCCMS_CategoryLinkedMenu.MenuItem.GetChild() param nIdx Invalid." ;
	}
	return this._arrChildren[nIdx] ;
}

Ext_JCCMS_CategoryLinkedMenu.MenuItem.prototype.GetChildrenCount = function ()
{
	return this._arrChildren.length ;
}







