<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCY_AdminAd 
 *
 * @access public
 */
class Ext_JCCY_AdminCategoryAd 
	extends W3B_Controller 
{
	const VIEW_FORM = 'VIEW_FORM' ;
	const MODEL_PREFERENCE = 'MODEL_PREFERENCE' ;
	const MODEL_CATEGORY = 'MODEL_CATEGORY' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_AdminCategoryAd(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller('Ext_JCCY_AdminAd',$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 模型
		$aModel = new Ext_JCCMS_ModelCategory($this->GetService()->GetServiceId()) ;
		$this->AddModel($aModel,self::MODEL_CATEGORY) ;
		
		$aRequest = $this->GetRequest() ;
		
		$aService = $this->GetService() ;
		$aExtension = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCCY') ;
		$aPreferenceModel = new JCAT_PreferenceModel($aExtension->GetPreference()) ;
		
		$nCategoryId = $aRequest->GetParam('nCategoryId') ;
		$sKey = '/ADCategory'.$nCategoryId ;
		$aPreferenceModel->SetItem($sKey,'sTopBanner','TopBanner') ;
		$aPreferenceModel->SetItem($sKey,'sTopBannerUrl','TopBannerUrl') ;
		$aPreferenceModel->SetItem($sKey,'sTopBannerCode','TopBannerCode') ;
		$aPreferenceModel->SetItem($sKey,'sBottomBanner','BottomBanner') ;
		$aPreferenceModel->SetItem($sKey,'sBottomBannerUrl','BottomBannerUrl') ;
		$aPreferenceModel->SetItem($sKey,'sBottomBannerCode','BottomBannerCode') ;
		$aPreferenceModel->SetItem($sKey,'sLeftSide','LeftSide') ;
		$aPreferenceModel->SetItem($sKey,'sLeftSideUrl','LeftSideUrl') ;
		$aPreferenceModel->SetItem($sKey,'sLeftSideCode','LeftSideCode') ;
		$aPreferenceModel->SetItem($sKey,'sRightSide','RightSide') ;
		$aPreferenceModel->SetItem($sKey,'sRightSideUrl','RightSideUrl') ;
		$aPreferenceModel->SetItem($sKey,'sRightSideCode','RightSideCode') ;
		$this->AddModel($aPreferenceModel,self::MODEL_PREFERENCE) ;
		
		// 创建并加载视图：
		$aView = new Ext_JCCY_ViewAdminAdForm($this,self::GetAdStorePath($this->GetService())) ;
		$aView->SetModel($aPreferenceModel) ;
		$this->AddView($aView,self::VIEW_FORM) ;

		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('添加城市','Ext_JCCY',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$aModel = $this->GetModel(self::MODEL_CATEGORY) ;
		$aView = $this->GetView(self::VIEW_FORM) ;
		$aView->SetViewVar('TheCategory',$aModel) ;
		
		do{
			$aView->ShowForm(false) ;
			
			$aRequest = $this->GetRequest() ;
			$nCategoryId = $aRequest->GetParam('nCategoryId') ;
			if($nCategoryId)
			{
				$aModel->FindBy('nCategoryId',$nCategoryId) ;
				if( !$aModel->Load() )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('指定的行业分类不存在（nCategoryId:%s）','Ext_JCCY',null,$nCategoryId),MSGMVC_BAD) ;
					break ;
				}
			}
	

			$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
	
			// 提交表单视图 Ext_JCCMS_PostFormView
			if( $aView->IsSubmitingForm() ) 
			{
				$aView->SetDataFromSubmited() ;
	
				// 用户输入校验
				if( $aView->VerifyData() )
				{			
					$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;	
					new JCAT_Message(JCAT_Language::SentenceEx('保存成功','Ext_JCCY',null),MSGMVC_OK) ;
				}
			}

			$aView->ShowForm(true) ;
			
		}while(0) ;
		
		$aFrame->RenderFrame($aView) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aService	W3B_Service
	 * @static
	 * @return	string
	 */
	static public function GetAdStorePath(W3B_Service $aService)
	{
		$aExtension = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCCY') ;
		if ( !$aExtension )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'扩展尚未载入：Ext_JCCY', 'Ext_JCCY', null
			)) ;
		}
		return $aExtension->GetDefaultUserRCDirectory() ;
	}
	
}

?>