<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCCMS_CreateNewClass 
 *
 * @access public
 */
class Ext_JCCY_AdminAnnouncement
	extends W3B_Controller 
{
	const MODEL_ANNOUNCEMENT = 'MODEL_ANNOUNCEMENT' ;
	const VIEW_FORM = 'VIEW_FORM' ;
	
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		
		// 创建并加载文档：Ext_JCCMS_PostDoc
		$aModel = new Ext_JCCY_ModelAnnouncement(Ext_JCCY_ModelAnnouncement::BASE) ;
		$this->AddModel($aModel,self::MODEL_ANNOUNCEMENT) ;
		
		// 创建并加载视图：Ext_JCCMS_PostFormView
		$aView = self::CreateAnnouncementForm($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_FORM) ;
		
		// 框架菜单路径		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('店铺管理','Ext_JCCY',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$nServiceId = $aService->GetServiceId() ;
		$aIdMgr = $aService->GetIdManager() ;
	
		// 认证
		$aAuthenticator = Ext_JCCY::CreateAuthenticator($nServiceId) ;
		
		// 服务管理员
		if(Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($nServiceId)->Authorize($aIdMgr))
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
			$aFrame->SetRequest($this->GetRequest()) ;
		}
		
		// 拥有发布商铺权限的用户
		else if($aAuthenticator->Authorize($aIdMgr))
		{
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		}
		
		else 
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$aModel = $this->GetModel(self::MODEL_ANNOUNCEMENT) ;
		$aView = $this->GetView(self::VIEW_FORM) ;
		$aView->ShowForm(false) ;
	
		// 前置条件检查
		$aRequest = $this->GetRequest() ;
		$nAId=$aRequest->GetParam('nAId') ;
		$nItemId=$aRequest->GetParam('nItemId') ;
		if( $nAId )
		{
			$aModel->FindBy('nAId',$nAId) ;
			if( !$aModel->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的内容不存在（nAId:%s）','Ext_JCCY',null,$nAId),MSGMVC_BAD) ;
				$aFrame->RenderFrame($aView) ;
				return ;
			}
			
			$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
		}
		
		else if( $nItemId )
		{
			$aModel->Set('nShopId',$nItemId) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nAId 或 nItemId','Ext_JCCY',null),MSGMVC_BAD) ;
			$aFrame->RenderFrame($aView) ;
			return ;
		}
		
		$aView->ShowForm(true) ;

		// 提交表单视图 Ext_JCCMS_PostFormView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->SetDataFromSubmited() ;
			$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{
				if( $this->IsCreateNew() )
				{
					$aModel->Set('nServiceId',$this->GetService()->GetServiceId()) ;
					$aModel->Set('nCreateTime',time()) ;
				}
				
				if( $aModel->Serialize() )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存成功','Ext_JCCMS',null),MSGMVC_OK) ;
					if( $this->IsCreateNew() )
					{
						$aView->ShowForm(false) ;
					}
				}
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;
				}
			}
		}
		
		

		$aFrame->RenderFrame($aView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function IsCreateNew()
	{
		return $this->GetRequest()->GetParam('nAId')==null ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ViewHtmlForm
	 */
	static public function CreateAnnouncementForm(JCAT_IController $aParent)
	{
		$aView = new JCAT_ViewHtmlForm('template.Ext_JCCY_ViewAdminAnnouncement.html',$aParent,'Ext_JCCY_ViewAdminAnnouncement') ;
		
		$aUICtrl = new JCAT_UICtrlHtmlSText('Title','标题') ;
		$aUICtrl->AddVerifier(new JCAT_UICtrlLengthVerifier(-1,240,false)) ;
		$aView->AddUICtrl($aUICtrl,'sTitle');
		
		$aUICtrl = new JCAT_UICtrlHtmlMText('Detail','内容') ;
		$aUICtrl->AddVerifier(new JCAT_UICtrlLengthVerifier(-1,-1,false)) ;
		$aView->AddUICtrl($aUICtrl,'sDetail') ;
		
		$aUICtrl = new JCAT_UICtrlHtmlSBox('Public','公开') ;
		$aUICtrl->AddItem('公开','1',true) ;
		$aUICtrl->SetNullValue('0') ;
		$aView->AddUICtrl($aUICtrl,'bPublic') ;
		
		return $aView ;
	}
	
}
?>