<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCCMS_CreateNewClass 
 *
 * @access public
 */
class Ext_JCCY_AdminAnnouncementList
	extends W3B_Controller 
{
	const MODEL_ANNOUNCEMENTS = 'MODEL_ANNOUNCEMENTS' ;
	const VIEW_LIST = 'VIEW_LIST' ;
	
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		
		// 创建并加载文档：Ext_JCCMS_PostDoc
		$aModel = new Ext_JCCY_AggModelAnnouncement() ;
		$this->AddModel($aModel,self::MODEL_ANNOUNCEMENTS) ;
		
		// 创建并加载视图：Ext_JCCMS_PostFormView
		$aView = new JCAT_ViewHtmlList('template.Ext_JCCY_AdminAnnouncementList.html',$this,'Ext_JCCY_AdminAnnouncementList') ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_LIST) ;
		
		// 框架菜单路径		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('店铺管理','Ext_JCCY',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$nServiceId = $aService->GetServiceId() ;
		$aIdMgr = $aService->GetIdManager() ;
	
		// 认证
		$aAuthenticator = Ext_JCCY::CreateAuthenticator($nServiceId) ;
		
		// 服务管理员
		if(Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($nServiceId)->Authorize($aIdMgr))
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
			$aFrame->SetRequest($this->GetRequest()) ;
		}
		
		// 拥有发布商铺权限的用户
		else if($aAuthenticator->Authorize($aIdMgr))
		{
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		}
		
		else 
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		
		$aModel = $this->GetModel(self::MODEL_ANNOUNCEMENTS) ;
		$aView = $this->GetView(self::VIEW_LIST) ;
	
		$this->DoAction() ;
		
		// 前置条件检查
		$aRequest = $this->GetRequest() ;
		$nItemId=$aRequest->GetParam('nItemId') ;
		$aModel->FindBy('nShopId',$nItemId) ;
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('指定的店家不存在（nItemId:%s）','Ext_JCCY',null,$nItemId),MSGMVC_BAD) ;
			$aFrame->RenderFrame($aView) ;
			return ;
		}
		
		

		$aFrame->RenderFrame($aView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ActionDel()
	{
		$aRequest = $this->GetRequest() ;
		$nAId = $aRequest->GetParam('nAId') ;
		if(!$nAId)
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nAId','Ext_JCCY',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aModel = new Ext_JCCY_ModelAnnouncement() ;
		$aModel->FindBy('nAId',$nAId);
		if( !$aModel->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('指定的内容不存在(nAId:%s)','Ext_JCCY',null,$nAId),MSGMVC_BAD) ;
			return ;
		}
		
		if($aModel->Delete())
		{
			new JCAT_Message(JCAT_Language::SentenceEx('内容已经删除','Ext_JCCY',null),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('内容删除失败','Ext_JCCY',null),MSGMVC_OK) ;
		}
	}
	
}
?>