<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_CreateNewPost 
 *
 * @access public
 */
class Ext_JCCY_AdminShop 
	extends Ext_JCCMS_AdminItem 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_AdminShop(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->Ext_JCCMS_AdminItem($aParent) ;
		
	}
	
	

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam('type',Ext_JCCY::CATEGORY_TYPE_TRADE) ;
		
		$aService = $this->GetService() ;
		$nServiceId = $aService->GetServiceId() ;
		
		$aIdMgr = $aService->GetIdManager() ;
		

		// 创建并加载文档：Ext_JCCMS_PostDoc
		$aModel = new Ext_JCCY_ModelShop($aService) ;
		$this->AddModel($aModel,Ext_JCCMS_AdminItem::MODEL_ITEM) ;
		
		// 创建并加载视图：Ext_JCCMS_PostFormView
		$aView = new Ext_JCCY_ViewShopForm($this) ;
		$aView->SetModel($aModel) ;
		$aView->SetViewVar('TheIdMgr',$aIdMgr) ;
		$this->AddView($aView,Ext_JCCMS_AdminItem::VIEW_ITEMFORM) ;
		
		// 框架菜单路径
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('发布店铺信息','Ext_JCCY',null)
		) ;
		
	
		// 权限要求
		$aAuthenticator = Ext_JCCY::CreateAuthenticator($nServiceId) ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		// 服务管理员
		if(Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($nServiceId)->Authorize($aIdMgr))
		{
			// nothing todo ... 
		}
		
		// 拥有发布商铺权限的用户
		else
		{
			// 非管理员，移除 推荐菜单
			$aView->RemoveUICtrl('Star') ;
			
			if($aAuthenticator->Authorize($aIdMgr))
			{
				// 替换成普通的框架
				$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
				$this->AddController($aFrame,Ext_JCCMS_AdminItem::CTLR_FRAME) ;
				
				// 找到该用户已经刊登的商铺
				$aUser = $aIdMgr->QueryIdentity(Ext_JCUser_Identity::ID_CLASS) ;
				$nUserId = $aUser->GetModel()->Get('nUserId') ;
				JCAT_ASSERT::ASSERT_($nUserId) ;
				
				$aDB = $aService->GetPlatform()->GetDefaultDB() ;
				$nItemId = $aDB->SelectOneField('Ext_JCCMS_Item','nItemId',"nUserId={$nUserId}") ;
				if($nItemId)
				{
					$aRequest->SetParam('nItemId',$nItemId);
				}
			}
		}
		
		// 附件
		$aViewAttas = $this->GetView(self::VIEW_ATTACHMENTS) ;
		$aViewAttas->SetViewVar('sAdminController','Ext_JCCY_AdminShopAttachment') ;
		
	}


	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function LoadCategorySelete()
	{
		parent::LoadCategorySelete() ;
		
		// 加载城市菜单
		$aService = $this->GetService() ;
		
		$aCategoryList = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId()) ;
		$aCategoryList->LoadByRoot(Ext_JCCY::CATEGORY_TYPE_CITY) ;
		
		$aView = $this->GetView('theViewItemForm') ;
		$aView->LoadCitiesMenu($aCategoryList) ;
	}
	


}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFQlQ0JuJURCRiUxNCVERCUxNyVFOCUzRiUyNCVGQyUwMCU4QiUxNCVDNSVENiVBNiU4MyUwMCVFNnAlMjQlOEIlMEQlMjklOTElRTIwJTkxNyUwNi1NJTI1WiUyMyVDOSUxMCVFOUolQjQlQTBtViVERHQlNUR0JTExJUEwJTQwJTk3WSUxN0UlRkI1dSVFMSVDRiVFOCVCOSVBMyVEOCU4OSUxNyU4OSUwM2El
QzAlOTklQjklOEZzJUVFJUI5dyU5NCVCQk13JTVCJUJBLSVENyVGMCVGMyUyQTclOEVzJUQ3JUExJUIzJTg1JTBCJUI2JTVDVCVBQiVBNVJyJUQ1JUNGJUFCJUE5cSU4QyU1QiVDQnIlOEQlQzZ0OSU5NyU4RCU1Q0klRDklRTglQUYlOTYlOTdyVDUlMDIlQzklRjIlQUElRjElREElRjYlRkElMkElQUYlN0UlNUMlQUUl
RTYlMEQlQkUlQTklRTQlQTIlMkMlOTYlMEIlREElOUQlMDclOEMlODUlODMlODZ1JTYwJUQyJUFGJUMxVCU1RSU5NiVCMmwlRjQlOTdlJUQ1JTE4JUQxJUUxJUUwJUMxJUU5JTlDJUFEZCU1RSVDOUglQUUlQzl6cDUlQkQlRDIlQjglOEYlRDhEJUY5JTVDJUQybSVEM3YlOEQlQ0YlMDQlOTIlRjklN0IlRDclMDglQ0JJ
Wl9JJUFBJUVBJTNCdyU1QiVCOCUyNjYlQkElRENDJUQ3JTE4TSUwQjUlNUUlQzklMDUlMTlNdyVCQiUyM2slMDk3JTIzJTFDdCVDMiU4QyUxOSVDNyVCOCVCMSU5RSVGNCUzRiVCQSVGNyUzRiVFRiVGRCVBMEMlOUFPJTg2WCVFNkMlOEN3JUUyJUVCKyVGQiVFOSVBMCVFNkMlOTAlQ0YlM0QlRDElRDFhJUFEJTI3JUMz
JTAwJUE1JTNEJTlEJUFGJUY0JURDJUVEJTJCJTJBJTI3JUZEVVElQzklMTUlQjklRDglRjclQzIlQjUlQkUlMTAlN0YlMDElQTlILiUxQSUxMSVENzhNJUMzVyVDRiVFRSVGRXglN0IlRkIlRUIlM0YlQzYxSSVCMiVFRlUlQzBOJUQyJUYzUCU5NmUlM0UlOTElRTQlMDIlOEMlODUlMDYlRjklQTAlRjQlOTclMDElQ0Ml
N0IlMDBkJUVBVCVCM2clQjclRUYlRkYlQkMlN0IlRkYlREIlN0YlRUYlREUlM0UlNDAlMUMlM0UlODYlODAlOTNfJUU0ajklRjklMTQlQTclRjklRDU4JUQwJUUxJUY2JTk3JUJGJUZGJUZEJUVCJUY3JUJCdyUzRiVERkMlRDglRTZjJTA4JUI2JTlDJUNGJUYzJUM1WCUxNSUwQiVGOSUxMWQlQjclMTdBJTk0JTEyJTNB
JUM2JUQ3JUYyWiUwRiUyQm4lMkMlMTg1MCVGQiUwNCVEOCVCQSU5NyVENyUyNlYlMEVYJUQxJTgzJUQwJUUzJUVEJUVDJUMxJUQwJUYzJURFJTA1JTNEM3olMDE5JUEwViVGRXJEJTBFeCUxNCU4QiUwRk8lODElMDAlRTElRjcxJUIxJUI2JThFJUY1JThCJTA2JUU0JTExJURFJUMyJThCJTE3JURCLSUwMiVBRiVFN3JR
JUU5JTE3JUU4JTdFNiVGOW4lRjclRjIlRTUlQjclREZIJTk2JUYxeCslOUMlODQlMDklMjclMUNkJTNDJUUxLSVENSVGMyVFM3UlOTAlRjJ1UiVFMCU1Q2QlNUU0JTEwJUQ4JTBCM2QlOTlHJTNFcSUyMSVBQyVFNDRWJUYxJUU1JUE0JTBFRCVEQiUwRiVEMiVBODMlQThhJTJCRCUwRCUzQiU4QiUwN1klMjdEJUNFJUE4
JTEwJTlCJTA4eSVFM1olRDRYTiU4RndVJUU4JUNGVCUyMiU5Mk4lOTAlQ0UlRUErJUY1eCslQjIlMEVWJTFCJTdFLSVDNG9iJUUycCUzQVFJJUNBVSVDMmMlOTUlRjglMjMlMTUlREYrJUU2MiVENiUyQjQlQkIlMkFOZyVFMEglQjklQTYlM0QlRjBsJTA2aSVENyUwQ0R3JTBELiU3Q1QlODglMTYlRUElQTklODkzJUJF
LSVFNCVCREklRDQlMjElN0MlQkRXJUMwYSVBOCUwNyUwQiVCNiUzQSVFMyUzRCU5NiVGOSUwOSVDQlhYJThCdTRDJTNFJTBFJUNDJUNCJUY2JUE5JUNFJTg1JUZBJTgzdGIlMDUlMjJEJURFLiVFQSUxQyU5QTklRjIlMjQlMjJUJTNEJTIxVCUyOCVCQSUyQTIlQTMlQ0IlMDFwJTEwJUJGJTA5JTg1aSVFNyVCNWhCJTIz
JTE2JURGJTBDJUFCJUQxJTVFJUI3TSVGOGYlMDYlQ0VCJUY1JUQyJUU5JTlCJUJEVlglMjIlRUElODRtJURDcSU4MSUzQSVDNzZyJTNCJTgxSCVEQSVDMGwlMDVpJUM2JTgzVHklRDBnQyVCQSUwNiU4MiVBMyU5NiVDQyU4RkhfJTYwJUM2JUIzbCUxNSU4OCVEOCUwQSVEMiU5MyUwRHg5JTA5cSU4NyVBRSUzRCU5RTEl
RENBJThCMSUxRiVENyVEMCVERiVGNyVCQyU5MFElM0YlQTAlMkJDJUJGJUEwJTJGJUY1MkEuJUQ0JUNEJUMzJTIyJUVCRCUyQyVFQiVFMCVFQyVGNSVGNCUxRCVFQyVBNyVDMiUzRSU5Qk8lQzB1RCVCQyU1RSUyMyVCRiUwOSUwRDclODglQjUlQTklN0ZRJUZCJTA4JTlDJTE0JUY4JUNEJUNDJTBDJUIzJUEwJTdCRiVC
M0ElQjElRUQzJUY0KyUwMCVERiUxOFpFJTFFJUVBJUMxJTEyJUQwMEIlQ0QlNUQlRTglMjhaJUE0JTNGJUUyJURCJUZBJTlDJUNFbi5qJUMyJTA3NyVCRSVCRSUxRWIlQTYlRDAlNUQlRTglMUElQUIlMDh1JTkyJUNFJTA5JTBGJUQxJUVCJTkxJUZFJTI2JUE5JTQwJUVEQyU3QyVFMSU5NSUwRVVsRiUzRiVBMTclRTAl
RDNFJURFMyVDQSVFOSUwQ0glRkJCJUQ4JUQ0YyU3QyU1QiVEMCU4RHolRUIlRDAlNUUlRjd6JTdGJUJGJTAxZyVFQSUxMyVDNyU3QyUzQTQlMjMlQTglN0RDMyVBMWclMTczJThGOCUyRlIlOTglQjdZJTFCNXQlQUQlOUN0JUUyJTIzJUNDJURDJUQ5WiVGN0YlNjAlRTYlODRwJUQwSyU4RSVGOSVGMWklQzZJJTgzOCU3
RSVGRSU5QyVGRSUxQXYlRkYlMDMlQjklQzBnUw!!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>