<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCMS_AdminItemAttachments 
 *
 * @access public
 */
class Ext_JCCY_AdminShopAttachment
	extends Ext_JCCMS_AdminItemAttachment 
{	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCMS_AdminItemAttachment(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
	}

	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$nServiceId = $aService->GetServiceId() ;
		$aIdMgr = $aService->GetIdManager() ;
	
		// 认证
		$aAuthenticator = Ext_JCCY::CreateAuthenticator($nServiceId) ;
		
		// 服务管理员
		if(Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($nServiceId)->Authorize($aIdMgr))
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
			$aFrame->SetRequest($this->GetRequest()) ;
		}
		
		// 拥有发布商铺权限的用户
		else if($aAuthenticator->Authorize($aIdMgr))
		{
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService) ;
		}
		
		else 
		{
			$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$aAuthenticator) ;
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$this->Doing() ;
		
		$aView = $this->GetView(parent::VIEW_ATTACHMENT) ;
		$aFrame->RenderFrame($aView) ;
	}

}

?>