<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCY_ShopList 
 *
 * @access public
 */
class Ext_JCCY_Announcement 
	extends W3B_Controller 
{
	const MODEL_ANNOUNCEMENT = 'MODEL_ANNOUNCEMENT' ;
	const VIEW_ANNOUNCEMENTP = 'VIEW_SHOP' ;

	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_Announcement(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		

		// 创建并加载文档：
		$aModelAnnouncement = new Ext_JCCY_ModelAnnouncement() ;
		$this->AddModel($aModelAnnouncement,self::MODEL_ANNOUNCEMENT) ;

		// 创建并加载视图：
		$aView = new JCAT_ViewHtml('template.Ext_JCCY_ViewAnnouncement.html',$this) ;
		$aView->SetModel($aModelAnnouncement) ;
		$this->AddView($aView,self::VIEW_ANNOUNCEMENTP) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{		
		$aRequest = $this->GetRequest() ;
		$aView = $this->GetView(self::VIEW_ANNOUNCEMENTP) ;
		$aView->SetViewVar('bDisplay',false) ;
			
		do {
			
			$nAId = $aRequest->GetParam('nAId') ;
			if(!$nAId)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nAId， 或参数无效','Ext_JCCY',null),MSGMVC_BAD) ;
				break ;
			}
			
			$aModel = $this->GetModel(self::MODEL_ANNOUNCEMENT) ;
			$aModel->FindBy('nAId',$nAId) ;
			$aModel->FindBy('bPublic','1') ;
			if( !$aModel->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的内容不存在(nAId:%s)','Ext_JCCY',null,$nAId),MSGMVC_BAD) ;
				break ;
			}
			
			
			$aView->SetViewVar('bDisplay',true) ;
			
		} while(0) ;
		
		$aWebpage = new JCAT_Webpage($this,$aView) ;
		$aWebpage->ShowView() ;
	}

}

?>