<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCHtmlFrameAdmin_Frame
 *
 * @access public
 */
class Ext_JCCY_Frame extends Ext_JCHtmlFrame_Controller
{
	const MODEL_TRADES = 'MODEL_TRADES' ;
	const MODEL_CITIES = 'MODEL_CITIES' ;
	const VIEW_BODY = 'VIEW_BODY' ;
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		// trade 参数
		$aRequest = $this->GetRequest() ;
		if($sTrade=$aRequest->GetParam('Trade'))
		{
			list($nTradeId) = explode('-',$sTrade) ;
			$aRequest->SetParam('nTradeId',$nTradeId) ;
		}
		
		
		$aService = $this->GetService() ;
		
		// 创建行业分类菜单
		$aTradeCagegories = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId()) ;
		$aTradeCagegories->LoadByRoot(Ext_JCCY::CATEGORY_TYPE_TRADE) ;
		$this->AddModel($aTradeCagegories,self::MODEL_TRADES) ;
		
		// 创建城市分类菜单
		$aCityCagegories = new Ext_JCCMS_ModelCategoryTree($aService->GetServiceId()) ;
		$aCityCagegories->LoadByRoot(Ext_JCCY::CATEGORY_TYPE_CITY) ;
		$this->AddModel($aCityCagegories,self::MODEL_CITIES) ;
		
		
		// 设置框架模板
		$aWebpageView = $this->GetView(Ext_JCHtmlFrame_Controller::CTLR_WEBPAGE) ;
		$aBodyView = $aWebpageView->GetBodyView() ;
		$aBodyView->SetTemplate('template.Ext_JCCY_Frame.html') ;
		
		// 初始化
		$this->InitializeView($aBodyView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeView(JCAT_IView $aBodyView)
	{
		$aRequest = $this->GetRequest() ;
		
		// 分类		
		$aCitySelect = new Ext_JCCMS_CategoryLinkedMenu('City','城市',Ext_JCCMS_CategoryLinkedMenu::FLAG_DEFAULT|Ext_JCCMS_CategoryLinkedMenu::VALUE_IS_ALL) ;
		$aCitySelect->LoadCategories($this->GetModel(self::MODEL_CITIES)) ;
		$aCitySelect->SetDataFromSubmited($aRequest) ;
		$aBodyView->AddUICtrl($aCitySelect) ;

		$aTradeSelect = new Ext_JCCMS_CategorySelect('Trade',false,true,0) ;
		$aTradeSelect->AddItem(JCAT_Language::SentenceEx('请选择行业','Ext_JCCY',null),'0') ;
		$aTradeSelect->LoadCategories($this->GetModel(self::MODEL_TRADES),Ext_JCCMS_CategorySelect::VALUE_IS_ALL) ;
		$aTradeSelect->SetDataFromSubmited($aRequest) ;
		
		// 
		//$aBodyView = new JCAT_ViewHtml('template.Ext_JCCY_Frame.html',$this,'Ext_JCHtmlFrameView') ;
		$aBodyView->AddUICtrl($aCitySelect) ;
		$aBodyView->AddUICtrl($aTradeSelect) ;
		$aBodyView->SetViewVar('TheIdMgr',$this->GetService()->GetIdManager()) ;
		
		$this->AddView($aBodyView,self::VIEW_BODY) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	Ext_JCCMS_ModelCategory
	 */
	public function GetCityCategoryTree()
	{
		return $this->GetModel(self::MODEL_CITIES)->GetRootCategory() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	Ext_JCCMS_ModelCategory
	 */
	public function GetTradeCategoryTree()
	{
		return $this->GetModel(self::MODEL_TRADES)->GetRootCategory() ;
	}


	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetADCode($sPos)
	{
		$aRequest = $this->GetRequest() ;
		$nTradeId = $aRequest->GetParam('nTradeId') ;
		
		// 行业分类路径
		$arrTradePath = array('') ;
		if($nTradeId)
		{
			$aTradeTree = $this->GetModel(self::MODEL_TRADES) ;
			$aTradeModel = $aTradeTree->GetModelById($nTradeId) ;
			if($aTradeModel)
			{
				$arrTradePath = $aTradeModel->GetCategoryPath() ;
			}
		}
		$arrTradePath = array_reverse($arrTradePath) ;

		// 
		$aExtension = $this->GetService()->GetExtensionManager()->GetLoadedExtension('Ext_JCCY') ;
		$aPreference = $aExtension->GetPreference() ;
		
		$sPhoto = null ;
		foreach($arrTradePath as $Trade)
		{
			
			$sKey = 'ADCategory'.($Trade?$Trade->Get('nCategoryId'):'') ;
			
			// 使用图片
			if( $aPreference->HasItem($sKey,$sPos) and $sPhoto=$aPreference->GetItem($sKey,$sPos) )
			{
				$sLink = $aPreference->GetItem($sKey,$sPos.'Url') ;
				
				$sPhotoSrc = JCAT_DownloadFile::GetHTTPAccessPath(Ext_JCCY_AdminCategoryAd::GetAdStorePath($this->GetService()).'/'.$sPhoto) ;
				$sCode = "<img src='{$sPhotoSrc}' border=0 />" ;
				if($sLink)
				{
					$sCode = "<a href='{$sLink}' target='_blank'>{$sCode}</a>" ;
				}
		
				return $sCode ;
			}
			
			// 使用代码
			if( $aPreference->HasItem($sKey,$sPos.'Code') )
			{
				return htmlspecialchars_decode($aPreference->GetItem($sKey,$sPos.'Code')) ;
			}
			
		}

		return '' ;
	}


	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function GetTrade()
	{
		$aRequest = $this->GetRequest() ;
		$nTradeId = $aRequest->GetParam('nTradeId') ;
		if(!$nTradeId)
		{
			return ;
		}
		
		$aTradeTree = $this->GetModel(self::MODEL_TRADES) ;
		return $aTradeTree->GetModelById($nTradeId) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetTradePath()
	{
		$aRequest = $this->GetRequest() ;
		$nTradeId = $aRequest->GetParam('nTradeId') ;
		if($nTradeId)
		{
			$aTradeTree = $this->GetModel(self::MODEL_TRADES) ;
			$aTradeModel = $aTradeTree->GetModelById($nTradeId) ;
			if($aTradeModel)
			{
				$arrTradePath = $aTradeModel->GetCategoryPath() ;
				array_shift($arrTradePath) ;
				array_shift($arrTradePath) ;
				
				return $arrTradePath ;
			}
			
			else 
			{
				return array() ;
			}
		}
		
		else
		{
			return array() ;
		}
	}
	
}

?>