<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCY_ShopList 
 *
 * @access public
 */
class Ext_JCCY_Index 
	extends W3B_Controller 
{
	const CONTROLLER_FRAME = 'CONTROLLER_FRAME' ;
	const VIEW_LIST = 'VIEW_LIST' ;
	
	const MODEL_STARSHOPS = 'MODEL_STARSHOPS' ;
	const MODEL_COMMENTS = 'MODEL_COMMENTS' ;
	const MODEL_ANNOUNCEMENTS = 'MODEL_ANNOUNCEMENTS' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_Index(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtmlList('template.Ext_JCCY_ViewIndex.html',$this) ;
		$this->AddView($aView,self::VIEW_LIST) ;
		
		// 推荐商家
		$aModel = new Ext_JCCY_AggModelShop($this->GetService()) ;
		$this->AddModel($aModel,self::MODEL_STARSHOPS) ;
		
		// 评论
		$aModel = new Ext_JCCMS_AggModelComment(true) ;
		$this->AddModel($aModel,self::MODEL_COMMENTS) ;
		
		// 商家动态
		$aModel = new Ext_JCCY_AggModelAnnouncement(Ext_JCCY_ModelAnnouncement::BASE|Ext_JCCY_ModelAnnouncement::ITEM) ;
		$this->AddModel($aModel,self::MODEL_ANNOUNCEMENTS) ;
		
		
		$aFrame = W3B_Controller::CreateController('Ext_JCCY_Frame',$this->GetService()) ;
		$this->AddController($aFrame,self::CONTROLLER_FRAME) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aView = $this->GetView(self::VIEW_LIST) ;
		$aFrame = $this->GetController(self::CONTROLLER_FRAME) ;
		
		// 推荐商家
		$aStarShopsModel = $this->GetModel(self::MODEL_STARSHOPS) ;
		$aStarShopsModel->FindBy('nStar',0,'>') ;
		$aStarShopsModel->FindBy('bPublic','1') ;
		$aStarShopsModel->FindSort('nStar') ;
		$aStarShopsModel->Load() ;

		// 评论
		$aCommentsModel = $this->GetModel(self::MODEL_COMMENTS) ;
		$aCommentsModel->FindBy('nServiceId',$this->GetService()->GetServiceId()) ;
		$aCommentsModel->FindSort('nItemId') ;
		$aCommentsModel->Load() ;

		// 商家动态
		$aAnnouncementsModel = $this->GetModel(self::MODEL_ANNOUNCEMENTS) ;
		$aAnnouncementsModel->FindBy('nServiceId',$this->GetService()->GetServiceId()) ;
		$aAnnouncementsModel->FindSort('nAId') ;
		$aAnnouncementsModel->SetCountPerPage(10) ;
		$aAnnouncementsModel->Load() ;
		
		// 网页title
		$aWebpage = $aFrame->GetView(Ext_JCHtmlFrame_Controller::CTLR_WEBPAGE) ;
		$aWebpage->SetTitle(PROJECT_NAME);
		$aFrame->RenderFrame($aView) ;
	}
	
}

?>