<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCY_ShopList 
 *
 * @access public
 */
class Ext_JCCY_Shop 
	extends W3B_Controller 
{
	const CONTROLLER_FRAME = 'CONTROLLER_FRAME' ;
	const MODEL_SHOP = 'MODEL_SHOP' ;
	const MODEL_ATTACHMENTS = 'MODEL_ATTACHMENTS' ;
	const MODEL_ANNOUNCEMENT = 'MODEL_ANNOUNCEMENT' ;
	const MODEL_SIMILAR = 'MODEL_SIMILAR' ;
	const VIEW_SHOP = 'VIEW_SHOP' ;

	const MODEL_COMMENTS = 'MODEL_COMMENTS' ;
	const VIEWNAME_COMMENTFORM = 'VIEWNAME_COMMENTFORM' ;
	const VIEWNAME_COMMENTS = 'VIEWNAME_COMMENTS' ;
	
	const CTLRNAME_POSTCOMMENT = 'CTLRNAME_POSTCOMMENT' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_Shop(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		$aService = $this->GetService() ;

		// 创建并加载文档：
		$aModel = new Ext_JCCY_ModelShop($aService,true) ;
		$this->AddModel($aModel,self::MODEL_SHOP) ;
		
		$aModelAttachments = new Ext_JCCMS_AggModelAttachment($aService) ;
		$this->AddModel($aModelAttachments,self::MODEL_ATTACHMENTS) ;
		
		$aModelAnnouncement = new Ext_JCCY_AggModelAnnouncement() ;
		$this->AddModel($aModelAnnouncement,self::MODEL_ANNOUNCEMENT) ;
		
		$aModelComments = new Ext_JCCMS_AggModelComment(true) ;
		$aModelComments->SetCountPerPage(10) ;
		$this->AddModel($aModelComments,self::MODEL_COMMENTS) ;
		
		$aModelSimilar = new Ext_JCCY_AggModelShop($aService) ;
		$aModelSimilar->SetCountPerPage(5) ;
		$this->AddModel($aModelSimilar,self::MODEL_SIMILAR) ;
		

		// 创建并加载视图：
		$aView = new JCAT_ViewHtml('template.Ext_JCCY_ViewShop.html',$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_SHOP) ;
		
		$aViewComments = new Ext_JCCMS_ViewCommentList($this) ;
		$aViewComments->SetModel($aModelComments) ;
		$this->AddView($aViewComments,self::VIEWNAME_COMMENTS) ;
		
		// 
		$aPostComment = W3B_Controller::CreateController('Ext_JCCMS_PostComment',$aService) ;
		$this->AddController($aPostComment,self::CTLRNAME_POSTCOMMENT) ;
		
		$aView = $aPostComment->GetView(Ext_JCCMS_PostComment::VIEW_COMMENTFORM) ;
		$this->AddView($aView,self::VIEWNAME_COMMENTFORM) ;
		
		
		$aFrame = W3B_Controller::CreateController('Ext_JCCY_Frame',$this->GetService()) ;
		$this->AddController($aFrame,self::CONTROLLER_FRAME) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{	
		$aFrame = $this->GetController(self::CONTROLLER_FRAME) ;
		$aViewShop = $this->GetView(self::VIEW_SHOP) ;
		$aViewShop->SetViewVar('bDisplay',false) ;
		
		$aRequest = $this->GetRequest() ;
		$nItemId = $aRequest->GetParam('nItemId') ;
		
		do {
			if(!$nItemId)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nItemId， 或参数无效','Ext_JCCY',null),MSGMVC_BAD) ;
				break ;
			}
			
			$aModelShop = $this->GetModel(self::MODEL_SHOP) ;
			$aModelShop->FindBy('nItemId',$nItemId) ;
			$aModelShop->FindBy('bPublic','1') ;
			if( !$aModelShop->Load() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的内容不存在(nItemId:%s)','Ext_JCCY',null,$nItemId),MSGMVC_BAD) ;
				break ;
			}
			
			// category id
			$aModelShop->Get('sTel') ;
			$nCategoryId = $aModelShop->Get('nCategoryId') ;
			$aFrame->GetRequest()->SetParam('nTradeId',$nCategoryId) ;
			
			
			// 发表评论
			$aCtlrPostComment = $this->GetController(self::CTLRNAME_POSTCOMMENT) ;
			//$aPostCommentRequest = $aCtlrPostComment->GetRequest() ;
			$aCtlrPostComment->MainRun() ;
			
			
			// 载入评论
			$aModelComments = $this->GetModel(self::MODEL_COMMENTS) ;
			$aModelComments->FindBy('nReplyTo',$nItemId) ;
			$aModelComments->Load() ;
			
			// 更新浏览次数
			// -------------
			// 更新 items 表中的冗余
			$aDB = $this->GetService()->GetPlatform()->GetDefaultDB() ;
			$aDB->Increase('Ext_JCCMS_Item','nView',"nItemId={$nItemId}") ;
			
			
			// 载入附件
			$aModelAttachments = $this->GetModel(self::MODEL_ATTACHMENTS) ;
			$aModelAttachments->FindBy('nItemId',$nItemId) ;
			$aModelAttachments->Load() ;
			
			
			// 载入商家动态
			$aModelAnnouncement = $this->GetModel(self::MODEL_ANNOUNCEMENT) ;
			$aModelAnnouncement->FindBy('nShopId',$nItemId) ;
			$aModelAnnouncement->FindBy('bPublic','1') ;
			$aModelAnnouncement->Load() ;
			
			
			// 相关商家
			$aModelSimilart = $this->GetModel(self::MODEL_SIMILAR) ;
			if($sKeywords = $aModelShop->Get('sKeywords'))
			{
				$arrKeywords = explode(' ',$sKeywords) ;
				$nKeywords = 0 ;
				foreach ($arrKeywords as $sOneKeyword)
				{
					if(empty($sOneKeyword))
					{
						continue ;
					}
					
					$aModelSimilart->FindBy('sKeywords',"%{$sOneKeyword}%",'LIKE') ;
					$aModelSimilart->FindBy('nItemId',$nItemId,'!=') ;
					$nKeywords ++ ;
				}
				
				if($nKeywords)
				{
					$aModelSimilart->Load() ;
				}
			}
			
			
			$aViewShop->SetViewVar('bDisplay',true) ;
			
		} while(0) ;
		
		
		// 网页title
		$aWebpage = $aFrame->GetView(Ext_JCHtmlFrame_Controller::CTLR_WEBPAGE) ;
		$aWebpage->SetTitle($aModelShop->Get('sTitle').'-'.PROJECT_NAME);
		$aFrame->RenderFrame($aViewShop) ;
	}

}

?>