<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCCY_ShopList 
 *
 * @access public
 */
class Ext_JCCY_ShopList 
	extends W3B_Controller 
{
	const CONTROLLER_FRAME = 'CONTROLLER_FRAME' ;
	const MODEL_SHOPS = 'MODEL_SHOPS' ;
	const MODEL_COMMENTS = 'MODEL_COMMENTS' ;
	const VIEW_LIST = 'VIEW_LIST' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCCY_ShopList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		

		// 创建并加载文档：
		$aModel = new Ext_JCCY_AggModelShop($this->GetService(),true) ;
		$this->AddModel($aModel,self::MODEL_SHOPS) ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtmlList('template.Ext_JCCY_ViewShopList.html',$this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_LIST) ;
		
		// 评论
		$aModel = new Ext_JCCMS_AggModelComment(true) ;
		$this->AddModel($aModel,self::MODEL_COMMENTS) ;
		
		$aFrame = W3B_Controller::CreateController('Ext_JCCY_Frame',$this->GetService()) ;
		$this->AddController($aFrame,self::CONTROLLER_FRAME) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{	
		$aViewList = $this->GetView(self::VIEW_LIST) ;
		$aFrame = $this->GetController(self::CONTROLLER_FRAME) ;
		
		// 评论
		$aCommentsModel = $this->GetModel(self::MODEL_COMMENTS) ;
		$aCommentsModel->FindBy('nServiceId',$this->GetService()->GetServiceId()) ;
		$aCommentsModel->Load() ;
		
		// 商家
		$this->Load() ;
		
		
		// 网页title
		$aWebpage = $aFrame->GetView(Ext_JCHtmlFrame_Controller::CTLR_WEBPAGE) ;
		$aWebpage->SetTitle(PROJECT_NAME);
		$aFrame->RenderFrame($aViewList) ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Load()
	{
		$nCountPerPage = 10 ;
		
		// 取得页数
		$aListPagination = $this->GetView(self::VIEW_LIST)->GetUICtrl('ListPagination') ;
		$nCurrentPageNum = $aListPagination->GetPageNumber() ;
		$nLimitStart = ($nCurrentPageNum-1)*$nCountPerPage ;
		
		$aRequest = $this->GetRequest() ;
		$sSQL = "select *, City.sName as CityName, Trade.sName as TradeName
			 from Ext_JCCMS_Item, Ext_JCCY_Shops, Ext_JCCMS_Category as City, Ext_JCCMS_Category as Trade" ;
		$sSQLWhere = " where Ext_JCCMS_Item.bPublic='1'
				and Ext_JCCMS_Item.nItemId=Ext_JCCY_Shops.nItemId
				and Ext_JCCY_Shops.nCity=City.nCategoryId and Ext_JCCMS_Item.nCategoryId=Trade.nCategoryId" ;
		$sSQLSearch = "" ;
		$sSQLOrderBy = " ORDER BY nStar desc" ;
		$sSQLLimit = " LIMIT {$nLimitStart},{$nCountPerPage}" ;
		

		// 行业分类
		$sTrade = $aRequest->GetParam('Trade') ;
		if($sTrade)
		{
			list(,$nTradeLft,$nTradeRgt) = explode('-',$sTrade) ;
			$sSQLSearch.= " and Trade.nLft>={$nTradeLft} and Trade.nRgt<={$nTradeRgt}" ;
		}
		
		// 城市分类
		$sCity = $aRequest->GetParam('City') ;
		if($sCity and preg_match('/^(\d+)\-(\d+)\-(\d+)$/',$sCity,$arrRes))
		{
			$sSQLSearch.= " and City.nLft>={$arrRes[2]} and City.nRgt<={$arrRes[3]}" ;
		}
		
		// 关键词
		$sKeywords = $aRequest->GetParam('Keywords') ;
		if($sKeywords)
		{
			$sKeywords = trim($sKeywords) ;
			$sKeywords = addslashes($sKeywords) ;
			$sSQLSearch.= " and (Ext_JCCY_Shops.sKeywords like '%{$sKeywords}%'
			 or Ext_JCCMS_Item.sTitle like '%{$sKeywords}%'
			 or Ext_JCCMS_Item.sDetail like '%{$sKeywords}%')" ;
		}
		
		$aDB = $this->GetPlatform()->GetDefaultDB() ;
		$aRecordSet4TotalCount = $aDB->GetFactory()->CreateRecordSet($aDB->GetConnect()) ;
		$aRecordSet = $aDB->GetFactory()->CreateRecordSet($aDB->GetConnect()) ;
		
		// 总数
		$sCountSQL = "select count(Ext_JCCMS_Item.nItemId) as nCount from Ext_JCCMS_Item, Ext_JCCY_Shops, Ext_JCCMS_Category as City, Ext_JCCMS_Category as Trade {$sSQLWhere}" ;
		if(!$aRecordSet4TotalCount->Query($sCountSQL) )
		{
			echo $aDB->GetError() ;
			return ;
		}
		$nTotalCount = $aRecordSet4TotalCount->GetField('nCount') ;
		
		// 排序
		$sSort = $aRequest->GetParam('sort') ;
		if(in_array($sSort,array('city','nItemId','nView','nComment')))
		{
			if($sSort=='city')
			{
				$sSQLOrderBy.= ", City.`sName`" ;
			}
			
			else 
			{
				$sSQLOrderBy.= ", `Ext_JCCMS_Item`.`{$sSort}` desc" ;
			}
		}
		
		// 查询店铺 explorer
		$sSQL.= $sSQLWhere.$sSQLSearch.$sSQLOrderBy.$sSQLLimit ;
		$aRecordSet->Query($sSQL) ;
		
		$aModelShopList = $this->GetModel(self::MODEL_SHOPS) ;
		$aModelShopList->SetCountPerPage($nCountPerPage) ;
		$aModelShopList->GetORM()->GetFieldsMappingRule()->AddField('CityName','CityName') ;
		$aModelShopList->LoadFromRecordset($aRecordSet,$nTotalCount) ;
	}

}

?>