<?php
/**
 * 扩展：Ext_JCCY
 * 
 * @access	public
 */
class Ext_JCCY extends W3B_Extension
{
	const PURVIEW_DOMAIN = 'Ext_JCCY' ; 
	const PURVIEW_PUBLISH_SHOP = 1 ; 
	
	const CATEGORY_TYPE_CITY = 'CITY' ;
	const CATEGORY_TYPE_TRADE = 'TRADE' ;
	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{
		$theClassTrustee->RegisterClass('Ext_JCHtmlFrame_Controller','Ext_JCCY_Frame') ;
	}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		$theEventDispatcher->RegisterHandle(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array(__CLASS__,'SetupAdminFrameMenu') , array()
				, Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
				
		$theEventDispatcher->RegisterHandle(
				Ext_JCCMS::EVENT_CATEGORY_SHOWOPERATIONS
				, array(__CLASS__,'SetCategoryOperations') , array()
				, Ext_JCCMS::EVENT_NAMESPACE) ;
				
		$theEventDispatcher->RegisterHandle(
				Ext_JCCMS::EVENT_ITEM_SHOWOPERATIONS
				, array(__CLASS__,'SetItemOperations') , array()
				, Ext_JCCMS::EVENT_NAMESPACE) ;
	}
	
	/**
	 * 配置 管理框架 菜单
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetupAdminFrameMenu(JCAT_IUICtrlHtmlMenu $theFrameMenu)
	{		
		$sMenuXML = '<Menu>
	<MenuItem text="信息" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminShopList">
		<MenuItem text="城市黄页" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminShopList">
			<MenuItem text="发布店铺信息" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminShop" />
			<MenuItem text="店铺管理" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminShopList" />
			<MenuItem text="添加城市" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminCity" />
			<MenuItem text="城市管理" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminCityList" />
			<MenuItem text="添加行业分类" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminTrade" />
			<MenuItem text="行业分类管理" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminTradeList" />
			
		</MenuItem>
		<MenuItem text="广告设置" package="Ext_JCCY" link="/?controller=Ext_JCCY_AdminCategoryAd" />
	</MenuItem>
</Menu>' ;

		$theFrameMenu->BuildMenuFromXML($sMenuXML,false) ;
	}
	
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;
		
		$aExtUser = $aService->GetExtensionManager()->GetLoadedExtension('Ext_JCUser') ;
		$aExtUser->RegisterPurview("黄页","发布商家信息",self::PURVIEW_DOMAIN,self::PURVIEW_PUBLISH_SHOP) ;
		
		
		// 注册 post 类型
		$aService->RegisterExtensionData(
				'Ext_JCCMS'
				, Ext_JCCMS::CATEGORY_TYPE
				, JCAT_Language::SentenceEx('城市','Ext_JCCY',null)
				, self::CATEGORY_TYPE_CITY ) ;
		$aService->RegisterExtensionData(
				'Ext_JCCMS'
				, Ext_JCCMS::CATEGORY_TYPE
				, JCAT_Language::SentenceEx('行业分类','Ext_JCCY',null)
				, self::CATEGORY_TYPE_TRADE ) ;
				
				
		// 注册默认控制器（网站首页）
		$aRequestDispatcher = $aService->GetRequestDispatcher() ;
		$aRequestDispatcher->SetDefaultController('Ext_JCCY_Index') ;	
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetCategoryOperations(Ext_JCCMS_ModelCategory $aCategory,$sCategoryType)
	{
		if($sCategoryType==self::CATEGORY_TYPE_TRADE) 
		{
			$nCategoryId = $aCategory->Get('nCategoryId') ;
			echo "[<a href='?controller=Ext_JCCY_AdminCategoryAd&nCategoryId={$nCategoryId}'><font color='red'>广告</font></a>]" ;	
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetItemOperations(Ext_JCCMS_ModelItem $aCategory,$sCategoryType)
	{
		if($sCategoryType==self::CATEGORY_TYPE_TRADE) 
		{
			$nItemId = $aCategory->Get('nItemId') ;
			echo "[<a href='?controller=Ext_JCCY_AdminAnnouncementList&nItemId={$nItemId}'><font color='red'>动态</font></a>]" ;	
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	Ext_JCUser_Authenticator
	 */
	static public function CreateAuthenticator($nServiceId)
	{
		$aAuthenticator = new Ext_JCUser_Authenticator() ;
		$aAuthenticator->AddAllowIdentity(Ext_JCUser_Identity::ID_CLASS) ;
		$aAuthenticator->AddPurview(Ext_JCCY::PURVIEW_PUBLISH_SHOP,Ext_JCCY::PURVIEW_DOMAIN,$nServiceId) ;
		
		return $aAuthenticator ;
	}
}

?>