<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 Ext_JCCMS_PostDoc 
 *
 * @access public
 */
class Ext_JCCY_ModelShop extends Ext_JCCMS_ModelItem
{
    const PROP_SHOP = 'SHOP' ;
    const PROP_CITY = 'CITY' ;
	
	static private $arrORMConf = array(
		
		'hasOne' => array(
						
			'Ext_JCCY_Shops'=>array(
				'hubtable' => 'Ext_JCCMS_Item'
				, 'table' => 'Ext_JCCY_Shops'
				, 'foreignKeyFrom' => 'nItemId'
				, 'foreignKeyTo' => 'nItemId'
				, 'property' => self::PROP_SHOP
			) ,

			'Ext_JCCMS_Category'=>array(
				'hubtable' => 'Ext_JCCMS_Item'
				, 'table' => 'Ext_JCCMS_Category'
				, 'foreignKeyFrom' => 'nCity'
				, 'foreignKeyTo' => 'nCategoryId'
				, 'property' => self::PROP_CITY
			) ,
		)
	) ;

	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCCY_ModelShop(W3B_Service $aService,$bFull=false,JCAT_DB $aDB=null)
	{
		$this->Ext_JCCMS_ModelItem( $aService, $bFull, $aDB ) ;
		
		$aORM = Ext_JCCY_ModelShop::CreateShareORM($bFull,$aDB) ;
		$this->SetORM($aORM) ;
	}
	
	
	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Load()
	{
		if( !parent::Load() )
		{
			return false ;
		}
		
		$nCity = $this->Get('nCity') ;
		$aDB = $this->GetORM()->GetDB() ;
		
		$sCityName = $aDB->SelectOneField("Ext_JCCMS_Category",'sName',"nCategoryId={$nCity}") ;
		$this->Set('CityName',$sCityName) ;
		
		return true ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_ORM
	 */
	static public function CreateShareORM($bFull=false,JCAT_DB $aDB=null)
	{
		$sORMConfName = $bFull? 'full': 'base' ;
		
		if( !isset(self::$arrShareORM[$sORMConfName]) )
		{
			self::$arrShareORM[$sORMConfName] = Ext_JCCMS_ModelItem::CreateShareORM($bFull,$aDB) ;
			$aORMRule = self::$arrShareORM[$sORMConfName]->CreateORMRuleFromConf('hasOne',self::$arrORMConf['hasOne']['Ext_JCCY_Shops']) ;
			self::$arrShareORM[$sORMConfName]->AddMappingRule($aORMRule) ;
		}

		return self::$arrShareORM[$sORMConfName] ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array
	 */
	static private $arrShareORM = array() ;
}

?>