<?php
/**
 * 扩展：Ext_JCHtmlFrame
 * 
 * @access	public
 */
class Ext_JCHtmlFrame extends W3B_Extension
{	
	const EVENT_NAMESPACE = "\\Ext\\JCHtmlFrame" ;
	
	const EVENT_REG_MENU = 'OnRegisterMenu' ;
	
	const EVENT_REG_ADMIN_MENU = 'OnRegisterAdminMenu' ;
	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{
		$theClassTrustee->DeclareClass('Ext_JCHtmlFrame_Controller',array('Ext_JCHtmlFrame_IController')) ;		
	}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		$theEventDispatcher->DefineEvent(self::EVENT_REG_ADMIN_MENU,self::EVENT_NAMESPACE
				, JCAT_Language::SentenceEx('注册后台管理界面的菜单','Ext_JCHtmlFrame',null)
				, array('Ext_JCHtmlFrameAdminMenu','W3B_Service') );

		$theEventDispatcher->DefineEvent(self::EVENT_REG_MENU,self::EVENT_NAMESPACE
				, JCAT_Language::SentenceEx('注册框架顶层菜单','Ext_JCHtmlFrame',null)
				, array('JCAT_IUICtrlHtmlMenu','W3B_Service') );
		
		
		$theEventDispatcher->RegisterHandle(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array(__CLASS__,'SetupAdminFrameMenu') , array()
				, Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
		
		// 事件：登录成功
		$theEventDispatcher->RegisterHandle(
				Ext_JCUser::EVENT_LoginSuccess
				, array(__CLASS__,'LoginSuccessed') , array()
				, Ext_JCUser::EVENT_NAMESPACE) ;

	}

	/**
	 * 配置 管理框架 菜单
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetupAdminFrameMenu(JCAT_UICtrlHtmlMenu $theFrameMenu)
	{
		$sMenuXML = '<Menu>
	<MenuItem text="用户" package="Ext_JCCY" link="/?controller=Ext_JCUser_AdminList">
		<MenuItem text="注册新用户" target="_blank" package="Ext_JCCY" link="/?controller=Ext_JCUser_Register" />
		<MenuItem text="用户管理" package="Ext_JCCY" link="/?controller=Ext_JCUser_AdminList" />
	</MenuItem>
</Menu>' ;

		$theFrameMenu->BuildMenuFromXML($sMenuXML,false) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @static
	 * @return	void
	 */
	static public function LoginSuccessed(Ext_JCUser_Identity $aUser,W3B_IController $aController)
	{
		$aRequest = $aController->GetRequest() ;
		$sForward = $aRequest->GetParam('sForward') ;
		if( $sForward and $sForward!='/' )
		{
			return ;
		}

		$aService = $aController->GetService() ;
		$aAuth = Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($aService->GetServiceId()) ;
		
		// 服务管理员
		if( $aAuth->AuthorizeID($aUser) )
		{
			$aRequest->SetParam('sForward','/?controller=Ext_JCHtmlFrame_AdminWelcome') ;
		}

		else
		{
			$aRequest->SetParam('sForward','/') ;
		}
	}
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;

		// 设置访问路由
		W3B_Platform::RegisterHTTPPublicController('Ext_JCHtmlFrame_AdminWelcome') ;
		$aRequestDispatcher = $aService->GetRequestDispatcher() ;
		$aRequestDispatcher->RegisterControllerAlias('Welcome','Ext_JCHtmlFrame_AdminWelcome') ;
	}

}

?>