<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCHtmlFrameAdmin_Frame
 *
 * @access public
 */
class Ext_JCHtmlFrameAdmin_Controller
	extends 	Ext_JCHtmlFrame_Controller 
	implements	JCAT_IHTTPPublicController
{
	const PARAM_MENU = 'PARAM_MENU' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aService				W3B_Service				执行服务
	 * @param	$aAuthenticator=null	JCAT_IAuthorizable		认证器
	 * @param	$aParent=null			JCAT_IController		父控制器 
	 * @return	void
	 */
	public function Ext_JCHtmlFrameAdmin_Controller(W3B_Service $aService,JCAT_IAuthorizable $aAuthenticator=null,JCAT_IController $aParent=null)
	{
		// 调用父类构造函数
		$this->Ext_JCHtmlFrame_Controller($aParent) ;
		
		// 缺省的认证器
		if(!$aAuthenticator)
		{
			$aAuthenticator = self::CreateAuthenticator($aService->GetServiceId()) ;
		}
		$this->SetAuthenticator($aAuthenticator) ;
		
		$this->SetService($aService) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IAuthorizable
	 */
	static public function CreateAuthenticator($nServiceId=0)
	{
		$aAuthenticator = new Ext_JCUser_Authenticator() ;
		$aAuthenticator->AddAllowIdentity(Ext_JCUser_Identity::ID_CLASS);
		$aAuthenticator->AddPurview(Ext_JCUser::SERVICE_ADMIN,Ext_JCUser::SERVICE_ADMIN_DOMAIN,$nServiceId) ;
		$aAuthenticator->AddPurview(Ext_JCUser::PLATFORM_ADMIN,Ext_JCUser::PLATFORM_ADMIN_DOMAIN,$nServiceId) ;
		
		return $aAuthenticator ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
	
		// 认证
		if( !$this->Authorize($aService->GetIdManager()) )
		{
		    $this->DenyAccess() ;
		}
		
		// 通过认证
		else 
		{
		    $this->RenderFrame() ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function RenderFrame(JCAT_IViewHtml $aMainView=null)
	{
	    if($aMainView)
	    {
	        $this->PutinView($aMainView) ;
	    }
	    
		// 配置菜单
		$theFrameMenu = self::CreateFrameMenu($this->GetService()) ;
		$theFrameMenu->SetName('Ext_JCHtmlFrameAdminMenu') ;
		$theFrameMenu->SetDirection(JCAT_UICtrlHtmlMenu::HORIZONTAL) ;
		$aTopMenuCssTheme = $this->CreateFrameMenuCSSTheme(1,$theFrameMenu->GetCSSTheme(),$theFrameMenu->GetUI()) ;
		$theFrameMenu->SetCSSTheme($aTopMenuCssTheme) ;

		// 创建 网页 Body 部分视图
		$aBodyView = new JCAT_ViewHtml('template.Ext_JCHtmlFrameAdminView.html',$this,'Ext_JCHtmlFrameAdminView') ;
		$aBodyView->AddUICtrl($theFrameMenu) ;
		$aBodyView->SetViewVar('theFrameMenu',$theFrameMenu) ;
	
		// 左侧菜单
		$aRequest = $this->GetRequest() ;
		$sMenuText = $aRequest->GetParam(self::PARAM_MENU) ;
		$aMenuItem = $theFrameMenu->GetItem($sMenuText,true) ;
		if( $aMenuItem )
		{
			$arrMenuPath = JCAT_UICtrlHtmlMenu::TracePath($aMenuItem) ;
			
			//
			$theFrameMenu->SetActiveByPath($arrMenuPath) ;
			
			reset($arrMenuPath) ;
			$aLeftMenu = $theFrameMenu->GetChildMenu(array(current($arrMenuPath))) ;

			if($aLeftMenu)
			{
				$aLeftMenuCssTheme = $this->CreateFrameMenuCSSTheme(2,$aLeftMenu->GetCSSTheme(),$aLeftMenu->GetUI()) ;
				$aLeftMenu->SetCSSTheme($aLeftMenuCssTheme) ;
				$aLeftMenu->SetIndent(0) ;

				$aLeftMenu->SetName('Ext_JCHtmlFrameAdminMenuLeft') ;
				$aBodyView->AddUICtrl($aLeftMenu) ;
			}
		}
		
		// 路径
		$arrPath = $aMenuItem? $theFrameMenu->TracePath($aMenuItem,false): array() ;
		$aBodyView->SetViewVar('arrAccessPath',$arrPath) ;

		$aWebpageView = new JCAT_Webpage($this,$aBodyView) ;
		$aWebpageView->ShowView() ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IUICtrlHtmlMenu
	 */
	static public function CreateFrameMenu(W3B_Service $aService)
	{
		$theFrameMenu = new JCAT_UICtrlHtmlMenu('Ext_JCHtmlFrameAdminMenu') ;
		
		// 定义样式
		$aCSSTheme = self::CreateFrameMenuCSSTheme(3,$theFrameMenu->GetCSSTheme(),$theFrameMenu->GetUI()) ;
		$theFrameMenu->SetCSSTheme($aCSSTheme) ;
		
		// 触发事件
		$aEventDispatcher = $aService->GetEventDispatcher() ;
		$aEventDispatcher->Emit(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array($theFrameMenu,$aService)
				, Ext_JCHtmlFrame::EVENT_NAMESPACE
		) ;

		return $theFrameMenu ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @param	$nLevel
	 * @return	JCAT_CSSTheme
	 */
	static function CreateFrameMenuCSSTheme($nLevel,JCAT_CSSTheme $aPrototype, JCAT_UIHtml $aUI)
	{
		$aCSSTheme = clone $aPrototype ;
		$aCSSTheme->SetUsingTheme("Ext_JCHtmlFrame_AdminTopMenuLv{$nLevel}") ;
		$aCSSTheme->DefineFile("Ext_JCHtmlFrame_AdminTopMenuLv{$nLevel}.css",$aUI) ;
		
		return $aCSSTheme ;
	}

	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_IUICtrlHtmlMenu
	 */
	private $aFrameMenu ;
}

?>