<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 Ext_JCHtmlFrameAdmin_Frame
 *
 * @access public
 */
class Ext_JCHtmlFrame_Controller
		extends 	W3B_Controller
		implements 	Ext_JCHtmlFrame_IController 
{
	const CTLR_WEBPAGE = 'CTLR_WEBPAGE' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aService		W3B_Service			执行服务
	 * @param	$aParent=null	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCHtmlFrame_Controller(JCAT_IController $aParent=null)
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
		$this->aTopLayoutFrame = new JCAT_HtmlLayoutFrame($this) ;
		$this->aTopLayoutFrame->SetFill(true,true) ;
		
		
		$aBodyView = new JCAT_ViewHtml('template.Ext_JCHtmlFrameView.html',$this,'Ext_JCHtmlFrameView') ;
		$aWebpageView = new JCAT_Webpage($this,$aBodyView) ;
		$this->AddView($aWebpageView,self::CTLR_WEBPAGE) ;
	}

	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		// 创建 网页视图
		$aWebpageView = $this->GetView(self::CTLR_WEBPAGE) ;
		$aWebpageView->ShowView() ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function RenderFrame(JCAT_IViewHtml $aMainView=null)
	{
		if($aMainView)
		{
			$this->PutinView($aMainView) ;
		}
	   
		$this->MainRun() ;
	}

	/**
	 * 取得顶层布局框架视图
	 * 
	 * @access	public
	 * @return	JCAT_HtmlLayoutFrame
	 */
	public function GetTopLayoutFrame()
	{
		return $this->aTopLayoutFrame ;
	}
	
	/**
	 * 取得顶层布局框架视图
	 * 
	 * @access	public
	 * @param	$aTopLayoutFrame		JCAT_HtmlLayoutFrame
	 * @return	void
	 */
	public function SetTopLayoutFrame(JCAT_HtmlLayoutFrame $aTopLayoutFrame)
	{
		return $this->aTopLayoutFrame = $aTopLayoutFrame ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$aView		JCAT_IViewHtml
	 * @return	void
	 */
	public function PutinView(JCAT_IViewHtml $aView)
	{
		$aView->SetViewVar('TheFrame',$this) ;
		$this->GetTopLayoutFrame()->AddView($aView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IUICtrlHtmlMenu
	 */
	static public function CreateFrameMenu(W3B_Service $aService)
	{
		$aFrameMenu = new JCAT_UICtrlHtmlMenu('TopMenu') ;
		$aFrameMenu->SetDirection(JCAT_UICtrlHtmlMenu::HORIZONTAL);
		
		$aCSSTheme = $aFrameMenu->GetCSSTheme() ;
		$aCSSTheme->SetUsingTheme('Ext_JCHtmlFrame_TopMenu') ;
		$aCSSTheme->DefineFile('Ext_JCHtmlFrame_TopMenu.css',$aFrameMenu->GetUI()) ;
		
		// 装载菜单
		$aEventDispatcher = $aService->GetEventDispatcher() ;
		$aEventDispatcher->Emit(Ext_JCHtmlFrame::EVENT_REG_MENU,array($aFrameMenu,$aService),Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
		
		return $aFrameMenu ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function DenyAccess()
	{
		$aWebpageView = $this->GetView(self::CTLR_WEBPAGE) ;
		$aWebpageView->SetTitle(JCAT_Language::SentenceEx('拒绝访问。','Ext_JCHtmlFrame',null)) ;
		$aWebpageView->SetBodyView(new JCAT_ViewHtml('template.Ext_JCHtmlFrameDenyAccess.html',$this,'Ext_JCHtmlFrameDenyAccess')) ;
		
		$aWebpageView->ShowView() ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_HtmlLayoutFrame
	 */
	private $aTopLayoutFrame ;
}

?>