<?php

class Ext_JCHtmlFrame_Setup extends W3B_ExtensionDefaultSetup 
{	
	/**
	 * 初始化平台资源（全新安装时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Platform
	 * @return	void
	 */
	public function InitializeResource(W3B_Platform $aPlatform)
	{
		parent::InitializeResource($aPlatform) ;
		
		// 创建权限
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		$aDB->Insert('Ext_JCUser_Purview',array(
			'sPurviewName' => '服务管理员' ,
			'nPurviewBit' => 1 ,
			'sPurviewDomain' => 'Ext_JCHtmlFrame:Admin'
		)) ;
	}
	
	/**
	 * 回收平台资源（完全卸载时被调用）
	 *
	 * @access	public
	 * @param	$aPlatform	W3B_Service
	 * @return	void
	 */
	public function ClearServiceResource(W3B_Service $aService) 
	{
		$this->ClearSrvRCBySrvId($aService) ;
		
		// 清除权限
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		$aDB->Delete('Ext_JCUser_Purview',"nPurviewBit=1 and sPurviewDomain='Ext_JCHtmlFrame:Admin'") ;
	}

}

?>
