<?php
/**
 * 扩展：Ext_JCMenuManager
 * 
 * @access	public
 */
class Ext_JCMenuManager extends W3B_Extension
{	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		$theEventDispatcher->RegisterHandle(Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array($this,'SetupMenu')
				, array(Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU)
				, Ext_JCHtmlFrame::EVENT_NAMESPACE ) ;
		$theEventDispatcher->RegisterHandle(Ext_JCHtmlFrame::EVENT_REG_MENU
				, array($this,'SetupMenu')
				, array(Ext_JCHtmlFrame::EVENT_REG_MENU)
				, Ext_JCHtmlFrame::EVENT_NAMESPACE ) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function SetupMenu(JCAT_UICtrlHtmlMenu $aMenu, W3B_Service $aService, $sEventName)
	{
		if( $sEventName==Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU )
		{
			$aAuthenticator = Ext_JCHtmlFrameAdmin_Controller::CreateAuthenticator($aService->GetServiceId()) ;
			if( $aAuthenticator->Authorize($aService->GetIdManager()) )
			{
				$sMenuXML = '<Menu>
		<MenuItem text="系统" package="Ext_JCSystem">
			<MenuItem text="服务" package="Ext_JCSystem">
				<MenuItem text="系统菜单" package="Ext_JCSystem" link="/?controller=Ext_JCMenuManager_Admin" />
			</MenuItem>
		</MenuItem>
	</Menu>' ;
				$aMenu->BuildMenuFromXML($sMenuXML,false) ;
			}
		}
		
		$aPreference = $this->GetPreference() ;
		$arrMenuSort = $aPreference->GetItem('/',$sEventName) ;
		
		if(!$arrMenuSort)
		{
			$arrMenuSort = $aMenu->GetMenuOrder() ;
			$aPreference->SetItem('/',$sEventName,$arrMenuSort) ;
		}
		
		else 
		{
			$arrAllMenuItems = array() ;
			$this->GetAllMenuItem($aMenu,$arrAllMenuItems) ;
			
			// 重建菜单
			$aMenu->ClearItem() ;
			$this->BuildMenu($arrAllMenuItems,$aMenu,$arrMenuSort) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function GetAllMenuItem(JCAT_IUICtrlHtmlMenu $aMenu,array & $arrMenuItems)
	{
		$aIterator = $aMenu->CreateItemIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aMenuItem = $aIterator->Current() ;
			$arrMenuItems[$aMenuItem->GetItemText()] = $aMenuItem ;
			
			// 递归处理下级菜单
			$aChildMenu = $aMenuItem->GetChildMenu() ;
			if($aChildMenu)
			{
				$this->GetAllMenuItem($aChildMenu,$arrMenuItems) ;
			}
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function BuildMenu(array & $arrAllMenuItems,JCAT_IUICtrlHtmlMenu $aMenu,array $arrMenuSort)
	{
		foreach($arrMenuSort as $sMenuItemTxt=>$arrChildMenu)
		{
			if( array_key_exists($sMenuItemTxt,$arrAllMenuItems) )
			{
				$aMenu->AddItem($arrAllMenuItems[$sMenuItemTxt]) ;
				
				// 递归处理下级
				if( is_array($arrChildMenu) )
				{
					$aChildMenu = new JCAT_UICtrlHtmlMenu('Menu:'.$sMenuItemTxt,$aMenu->GetCSSTheme()) ;
					$arrAllMenuItems[$sMenuItemTxt]->SetChildMenu($aChildMenu) ;
					
					$this->BuildMenu($arrAllMenuItems,$aChildMenu,$arrChildMenu) ;
				}
			}
			
			else
			{
				$aMenu->AddItem( new JCAT_UICtrlHtmlMenuItem($aMenu,$sMenuItemTxt) ) ;
			}
		}
	}

	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;
		
		//Ext_JCMenuManager_Admin
	}

}

?>