<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCMenuManager_Admin 
 *
 * @access public
 */
class Ext_JCMenuManager_Admin 
	extends W3B_Controller 
{
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCMenuManager_Admin(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}
	
	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{		
		// 
		$aRequest = $this->GetRequest() ;
		if( !$aRequest->GetParam('menu') )
		{
			$aRequest->SetParam('menu',Ext_JCHtmlFrame::EVENT_REG_MENU) ;
		}
		
		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('系统菜单','Ext_JCCMS',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$aView = new JCAT_ViewHtml('template.Ext_JCMenuManager_Admin.html',$this) ;
		$aClassTrustee = $aService->GetClassTrustee() ;
		$aRequest = $this->GetRequest() ;
		
		$this->DoAction() ;

		// 读取当前使用的菜单
		// ---------------------------------
		$sMenu = $aRequest->GetParam('menu') ;
		if( !$sMenu or $sMenu=='frontend' )
		{
			// 	前台菜单
			$sFrontFrameClass = $aClassTrustee->QueryClass('Ext_JCHtmlFrame_Controller') ;
			$aMenu = call_user_func_array(array($sFrontFrameClass,'CreateFrameMenu'),array($aService)) ;
		}
		
		else 
		{
			// 	后台菜单
			$sBackendFrameClass = $aClassTrustee->QueryClass('Ext_JCHtmlFrameAdmin_Controller') ;
			$aMenu = call_user_func_array(array($sBackendFrameClass,'CreateFrameMenu'),array($aService)) ;
			
		}
		
		$aView->SetViewVar('sTheMenuJson',json_encode($aMenu->GetMenuOrder())) ;

		$aFrame->RenderFrame($aView) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function ActionSave()
	{
		$aRequest = $this->GetRequest() ;
		$sJsonMenuOrder = $aRequest->GetParam('jsonMenuOrder') ;
		
		$aPreference = $this->GetExtsPreperence() ;
		
		$sMenu = $aRequest->GetParam('menu') ;
		$sPreferenceItemName = (!$sMenu or $sMenu=='frontend')?
					Ext_JCHtmlFrame::EVENT_REG_MENU: Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU ;
					
		$aPreference->SetItem('/',$sPreferenceItemName,json_decode($sJsonMenuOrder,true)) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function ActionClearAll()
	{
		$aRequest = $this->GetRequest() ;
		$sMenu = $aRequest->GetParam('menu') ;
		$sPreferenceItemName = (!$sMenu or $sMenu=='frontend')?
					Ext_JCHtmlFrame::EVENT_REG_MENU: Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU ;
					
		$aPreference = $this->GetExtsPreperence() ;
		$aPreference->DeleteItem('/',$sPreferenceItemName) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IPreference
	 */
	public function GetExtsPreperence()
	{
		$aService = $this->GetService() ;
		$aExtensionMgr = $aService->GetExtensionManager() ;
		$aExtension = $aExtensionMgr->GetLoadedExtension('Ext_JCMenuManager') ;
		
		return $aExtension->GetPreference() ;
	}
}

?>