<?php
/**
 * 扩展：Ext_JCStaticPage
 * 
 * @access	public
 */
class Ext_JCStaticPage extends W3B_Extension
{
	/**
	 * 取得扩展名称
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionName()
	{
		return 'Ext_JCStaticPage' ;
	}

	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('静态网页','Ext_JCStaticPage',$sLanguage) ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('','Ext_JCStaticPage',$sLanguage) ;
	}
	
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function GetVersion()
	{
		return new JCAT_Version(1,0,0,0,'') ;
	}
	
	/**
	 * 取得扩展的兼容版本号
	 * 扩展自此版本以来，接口未发生任何变化，依赖此版本的其它扩展，可在当前版本上正常工作。
	 *
	 * @access	public
	 * @static 
	 * @return	void
	 */
	static public function GetCompatibleVersion()
	{
		return self::GetVersion() ;
	}

	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{}
	
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;

		
		// 注册菜单配置函数
		$aEventDispatcher = $aService->GetEventDispatcher() ;
		$aEventDispatcher->RegisterHandle(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array(__CLASS__,'SetupAdminFrameMenu') , array()
				, Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
				
				
		W3B_Platform::RegisterHTTPPublicController('Ext_JCStaticPage_Display') ;
	}

	/**
	 * 配置 管理框架 菜单
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetupAdminFrameMenu(JCAT_UICtrlHtmlMenu $theFrameMenu)
	{
		$sMenuXML = '<Menu>
	<MenuItem text="静态网页" package="Ext_JCStaticPage" link="?controller=Ext_JCStaticPage_AdminList">
		<MenuItem text="创建静态网页" package="Ext_JCStaticPage" link="/?controller=Ext_JCStaticPage_AdminPage" />
		<MenuItem text="管理静态网页" package="Ext_JCStaticPage" link="/?controller=Ext_JCStaticPage_AdminList" />
	</MenuItem>
</Menu>' ;
	
		$theFrameMenu->BuildMenuFromXML($sMenuXML,false) ;
	}
}

?>