<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCStaticPage_AdminList 
 *
 * @access public
 */
class Ext_JCStaticPage_AdminList 
	extends W3B_Controller 
{
	
	const MODEL_PAGE_LIST = 'theModelPageList' ;
	const VIEW_PAGE_LIST = 'theViewPageList' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCStaticPage_AdminList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_BAD) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_DEBUG) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
		
		$aService = $this->GetService() ;

		// 创建并加载文档：Ext_JCStaticPage_Document
		$aModel = new Ext_JCStaticPage_AggModel($aService->GetServiceId()) ;
		$this->AddModel($aModel,self::MODEL_PAGE_LIST) ;

		// 创建并加载视图：Ext_JCStaticPage_FormView
		$aView = new Ext_JCStaticPage_ViewAdminList($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_PAGE_LIST) ;
		
		
		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('管理静态网页','Ext_JCStaticPage',null)
		) ;		
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public 
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aView = $this->GetView(self::VIEW_PAGE_LIST) ;
		$aModel = $this->GetModel(self::MODEL_PAGE_LIST) ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		$this->DoActionDelete() ;
		
		$aModel->Load() ;

		
		$aFrame->RenderFrame($aView) ;
	}

	/**
	 * 操作：删除
	 *
	 * @access	private
	 * @return	void
	 */
	private function DoActionDelete()
	{
		$aRequest = $this->GetRequest() ;		
		if( !$aRequest->GetParam('action') or $aRequest->GetParam('action')!=='delete' )
		{
			return ;
		}
		$aRequest->RemoveParam('action') ;
		
		$nStaticPageId = $aRequest->GetParam('nStaticPageId') ;
		if( !is_numeric($nStaticPageId) or $nStaticPageId<1 )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nStaticPageId, 或参数无效。','Ext_JCStaticPage',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aService = $this->GetService() ;
		$aModel = new Ext_JCStaticPage_Model($aService->GetServiceId()) ;
		$aModel->FindById($nStaticPageId);
		
		if(!$aModel->Load())
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法找到Id为：%s 的记录。','Ext_JCStaticPage',null,$nStaticPageId),MSGMVC_BAD) ;
			return ;
		}
		
		if($aModel->Delete())
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除网页成功。','Ext_JCStaticPage',null),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除网页失败。','Ext_JCStaticPage',null),MSGMVC_BAD) ;
		}
		$aRequest->RemoveParam('nStaticPageId') ;
	}
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQzFuJURCRiUxMCVCRCUxNyVFOCUzRiUyNCVGQyUwMCU4QiUxNCVBOSVENiVBMSU4MyUwMCUxMkklQjElQTIlQkQlMkIlOTElRTIlRDIlOTYuJTA2JTIzbyUyNSU4QSUyQiVDOSUxMGlIJUIyJUEwa04lQjklRjQlNUMlRjQlMTAlQTAlNDAlOEY5JTE3RSVGQjV1JUUxJUNGJUU4JTFCJTJBciU5QyUwMiVC
NSUwM2IlQjElQ0IlRDklOTl5JUYzJURFJUNDJUE2diVERCVERSUxNiVCNmVrblolQTYlREFJajclRTglREYlODAlQzFZJUNDJUNCJUU1QiUyOSVCOSVFQyVBNSVFNUQlM0IlODElQjUlQUUlREJabSVCMiU5OCVDOVolQUElQTQlQUMlRjUlOTYlOEIlQTklMUMlOTUlQjUlNDAlM0FpWSUzQjclNUIlM0QlOTUlOTYlM0Yu
JTk2JUIzJTlBJUI3LiVFNSVCQyVDOCUxNnMlM0ElNUQlMDZOJUJGTCVDQmwlRDRLJUM3JUIyZiUxQyVFOSVGNCVENSUxQyU5NSUxNiU4NSUyQ2olMjMlREElOEYlRkUlRUJ2JUU5JTJDZVpKLlclRjR3dCUzRCVCOSVBRSUwQSVGOCVBMiUyQyU5RSVDRSUyNFlNVCVGNXQlM0N5JTdEb2slQUMlMTglQzclOUJrSSUyQyVC
RiVCMyVCNyU5OSVBRCVFM1AlRDElM0YlQjYlQjUlRDElMjRTV0s5JUE3SyVERCVERSVFRSVFOCVCNiU4MCU5QiVDNiVGQSUzRUslMUMlRUQlMDQlMTYlRTNZJUZGVyUwNyVGRiVDQiVFRWklMTVSJTdGNiVDNCVEMCUxRmJaTSVCNyUwQTIlOUYlMEYlQUElM0YlMDQlQjklNUVLJUY4VSU5OCVGNWwlMTglQTAlMkElQ0Yl
QzZXeiVFRSVGNiU4QyU4QXFvJTk5JTk1ckkuJUU2QTglRUIlODklRjglQjclOTAlOEElRTRCJUExJTg2JUFEJUZEJTEwJUIzJUIzJTE3JUY3JUJGJUJEJUJCJUZCJUY5JTJGJUVEJTg0JTI0JTI5JUVDJUJBaWslODElRDMlOEMlMkYlOTklMkMlMEE0JTg4JTVDJTgwMSVBRiU0MCUzRSUyOSVGRDQlODAlN0UlMDAlNDAl
MjYlQkYlQ0NfJURDJTdEJUZDJUZEJUZFJUUzJTJGJUZGJTdDeCVGNyUwMHElRkMlMjUlMDQlOUMlREMlMkNVJThCJUYxYyU5QyVGQVclRTMlNDAlODclQkIlOUYlRkUlRkMlRkIlOEZfJUVGJTNGJUJDJTNGJTQwJUQwJUUwJTNEJTg2cCUxNiVCM1klM0ElQkZSJUQ5JTVDJTdFJTA2JUQ5JUVERSUxMCU4NSU4NCU4RSVF
MSU4RCVCQyVBOSVBNiUxMSUxNiUwMyU5NyUxNSVCMCVGMyUwOCVEODglQzhrUlUlMERURSVDRiU4MyUyMiVFQSU4RCUzRCUxOHolREUlN0RLJUNGJThFJTFFQiUwQSVBOCVBNSVCQiUxOCU5MSUwMyVERSVDNiVGQyVEMyU4QislNDAlRjglN0ROJTVDJUREJTVFVSUyRiUxQyU5MCUxNiVDOCVCQyU3RSVCRCVERCUyMiVG
MGYlMjYlRTdlJUY1JTE0JUVEJUZGTSVCRSVEQiVCRHklRjMlRUQ3JUQySSVCQyVCMCU5RiVCNHhfNFglM0ZxJTk5JUIwVCVEN2UlOEElQkJNJUM1JUUyJTI2JUNFJTAzJTE1eUMlMTUlQzRtJTNGJTg4JUM3JUFCK24lMUElRkQlMkNpJTg1JTk5WEUlN0QlQjElRTElM0ElMkYlQ0YlRkFiJUM1dSVBNiVDMmklQTglQTJp
JUZCJTE0JTNFJUY1K1ZuJTEwJUU3JTNBJUYyJUFFJUMyJUJDUCU5MSUzQiUyOSU4MyVCOCVBMyVBNyUxNyUxM3NoJUMwNyVDRVUlOTglODclQUElMUIlOEYlODEzJUFFJUNFJTExJTE2JUQzJTNCJUIwJUU1JThBJUYyRSVGOSUwMCUzQiUxRiUwMldHTiUyQiVDRSVDNCU5QWMxWiU3RSUwOSU1QiVDNyUxMiU5OSVCMDg4
dCU5RCVDNCU4OWYlQUZaQ0dYJTExJUZFJUQ5JUVDWDElOTclMUIlMTclQjclMEMlQkJQbCVFQSU4MSVDQkh1RXAlMUIlODglMEV4eFhjJUUzdCU5MyVGOCUyQ0slREElRTFGJTk4UXIlQUMlMjIlMjElMTQlQzdiMXYlMUQlRjUlQjklMTMlMDElN0QlNUMlQzIlNjAlOUIlQzQlMDMlMUYlQzIlQjclQjglQkZmJUZEJTBE
JUNFUyU4MXolM0QlQzVyJUMyJTgxVlMlREVFJTdFJTAzJURDbyVCQiVFN0JFJUYxJTI0JTBGJUM0JTYwJTdEJUVFVCUxOCVGQiVEQSVBMDUlRTUlRTklRjYlOTM2JThGJUY5cCU4NCUzQ2ElN0QlODElM0MlMUQlRTglRDAlMDElRjYlNDAxJTBGa0p6JTYwTSVBMSU4OSUzQiVDNiUzRCU1QkMlMDMlMEIlRjUlM0ElRDAl
RkU2JTlDTyUwNiU4MSVFMCVFRSU5RU9uJTBEJUEwdSU4NCVERSVCMCU4RCVEOCU4NCUxOXhtJTA4JTEzJUI1JUEzJUJGJTJDJUUxRislRDglM0ElMTBtJTI3JTEwJTgyJUNFJUU4USUwQiVCMSU4OSUxNyU4OCU4OHJYJUIwJTIzJTBGJUQ1JUNFJURCJUI4JTg3TiVDQyU4NCUwRCUzQXMlRTclMkMlMjMlRkUlQzIlMEEl
RDElRjNIJTg1JUU4dSUxMyVEQyUzQSVFOCUyQiVFOUo1JTdCJUIwJTI1JTdFJTBBJTFGJUY4JUFEJUEzJUJDJUREQiU1RSUxRiVEQyVBOU8lMUIlQ0MlMDNwJTg2JUMwJTE5YiUwRk0lOTklMjUuJUY4JUI3UCU5RiVDM29JNyU4MXglRTQlODAlRUUlQTFOJTNEJTAwJUVGJTE4MyUyMXAlOTclQzMlMTYlODclRDYlODB6
JTg0JTk4JUVFRSU4RSU5OSVBNHklMjElREQlMDclRjAlOEYlQ0UlQzAlQzMlM0YlQkYlRTAlRDklNUUlRkIlMjYlQjgwJTNEJUM5RCU4MyVFNiUxNCVGRCVGMyVBQiVCRSUxMSVENmwlM0ZnJUQxJTE0JUIzJUUwJTBFJUMxVyVBMU4lQUYlMEUlOUUlMEQlQ0MlMDQ4JUYzVjUlRTclQzIzJUUzJUQ1JUNCJTk3JUY0JUQ0
dyVGRiUwMiUxRSUxNGQlQzY!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>