<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCStaticPage_CreateNewPage 
 *
 * @access public
 */
class Ext_JCStaticPage_AdminPage 
	extends W3B_Controller 
{
	const MODEL_STATIC_PAGE = 'theModelStaticPage' ;
	const VIEW_FORM_STATIC_PAGE = 'theViewFormStaticPage' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCStaticPage_AdminPage(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_BAD) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_DEBUG) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 
				
		$aService = $this->GetService() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aService);
		
		// 创建并加载文档：Ext_JCStaticPage_Document
		$aModel = new Ext_JCStaticPage_Model($aService->GetServiceId()) ;
		$this->AddModel($aModel,self::MODEL_STATIC_PAGE) ;
		
		// 创建并加载视图：Ext_JCStaticPage_FormView
		$aView = new Ext_JCStaticPage_ViewForm($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_FORM_STATIC_PAGE) ;
		
		// 初始化
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('创建静态网页','Ext_JCStaticPage',null)
		) ;		
	}

	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aView = $this->GetView(self::VIEW_FORM_STATIC_PAGE) ;
		$aModel = $this->GetModel(self::MODEL_STATIC_PAGE) ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}

		// 将参数 Name 改为小写
		$aRequest = $this->GetRequest() ;
		$sPageName = $aRequest->GetParam('Name') ;
		$sPageName = strtolower($sPageName) ;
		$aRequest->SetParam('Name',$sPageName) ;

		$aView->SetDataFromSubmited($aRequest) ;

		// 加载指定的网页
		$aModel->FindBy('nServiceId',$aService->GetServiceId()) ;
		$aModel->FindBy('sName',$sPageName) ;
		$aModel->Load() ;

		// 提交表单视图 Ext_JCCMS_PostFormView
		if( $aView->IsSubmitingForm() ) 
		{
			$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;

			// 用户输入校验
			if( $aView->VerifyData() )
			{								
				if( $aModel->Serialize() )
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存成功','Ext_JCCMS',null),MSGMVC_OK) ;
					$aView->ShowForm(false) ;
				}
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('保存失败','Ext_JCCMS',null),MSGMVC_BAD) ;					
				}
			}
		}
		
		else 
		{
			$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
		}

		$aFrame->RenderFrame($aView) ;
	}

}

?>