<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 W3B_InstalledExtensionList
 *
 * @access public
 */
class Ext_JCSystem_ExtensionDepenceConfirm extends W3B_Controller 
{
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_ExtensionDepenceConfirm(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
		
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
		// 
		$aAuthenticator = new JCAT_CommonAuthenticator() ;
		$aAuthenticator->AddAllowIdentity('Ext_JCUser_Identity');
		$aAuthenticator->AddPurview(Ext_JCUser::SERVICE_ADMIN,Ext_JCUser::SERVICE_ADMIN_DOMAIN) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		
		$aWebpage = new JCAT_Webpage($this) ;
	
		// 认证：执行控制器
		if( !$this->Authorize($aService->GetIdManager()) )
		{
			$aWebpage->SetTitle(JCAT_Language::SentenceEx('拒绝访问。','Ext_JCAdminFrame',null)) ;

			// 创建 网页 Body 部分视图
			$aBodyView = new JCAT_ViewHtml('template.Ext_JCAdminFrameDenyAccess.html',$this,'Ext_JCAdminFrameDenyAccess') ;
			$aWebpage->SetBodyView($aBodyView);
		}
		
		else 
		{
			$aRequest = $this->GetRequest() ;
			
			JCAT_ASSERT::ASSERT_(isset($_REQUEST['arrExtNames']),JCAT_Language::SentenceEx('缺少参数 arrExtNames','Ext_JCSystem',null));
			JCAT_ASSERT::ASSERT_ISTHESE($_REQUEST['arrExtNames'],array('array:string'),JCAT_Language::SentenceEx('参数 arrExtNames 必须为字符串数组','Ext_JCSystem',null));
		
			// get extension tree of current service
			$aPlatform = $this->GetPlatform() ;
			$aSvrExtentsionManager = $aService->GetExtensionManager() ;
			
			$sAction = $aRequest->GetParam('action') ;
			$sAction = strtolower($sAction) ;
			switch ($sAction)
			{
				case 'unsetup' :
					$aExtentsionManager = $aPlatform->GetExtensionManager() ;
					$bRevert = true ;
					break ;

				case 'enable' :
					$aExtentsionManager = $aPlatform->GetExtensionManager() ;
					$bRevert = false ;
					break ;

				case 'disable' :
					$aExtentsionManager = $aSvrExtentsionManager ;
					$bRevert = true ;
					break ;
				
				default :
					JCAT_ASSERT::ASSERT_(0,'!?')  ;
			}
			
			$aExtensionDependenceTree = $aExtentsionManager->GetExtensionDependenceTree() ;
			$aSvrExtensionDependenceTree = $aSvrExtentsionManager->GetExtensionDependenceTree() ;
			
			$arrExtItems = array() ;
			$arrExtensions = array() ;
			$arrDependExtensions = array() ;
			foreach ($_REQUEST['arrExtNames'] as $sExtName)
			{
				$aItem = $aExtensionDependenceTree->GetDependenceItem($sExtName) ;
				$arrExtItems[] = $aItem ;
				$arrExtensions[] = $aItem->GetItemName().'('.$aItem->GetItemVersion().')' ;
				
				// 受影响的扩展
				$aIterator = new W3B_DependenceAdvIterator($aItem,$bRevert,0) ;
				for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
				{
					$aItem = $aIterator->Current() ;
					$sItemName = $aItem->GetItemName() ;
					
					if( $sAction!='enable' or !$aSvrExtensionDependenceTree->GetDependenceItem($sItemName) )
					{
						$arrDependExtensions[] = "{$sItemName} (".$aItem->GetItemVersion().')' ;
					}
				}
			}
			
			$arrDependExtensions = array_unique($arrDependExtensions) ;
			

			$aView = new JCAT_ViewHtml('template.Ext_JCSystem_ViewExtensionDepenceConfirm.html',$this,'Ext_JCSystem_UnsetupConfirm') ;
			$aView->SetViewVar('arrExtItems',$arrExtItems) ;
			$aView->SetViewVar('arrExtensions',$arrExtensions) ;
			$aView->SetViewVar('arrDependExtensions',$arrDependExtensions) ;
			$aView->SetViewVar('sAction',$sAction) ;
			$aView->SetViewVar('bRevert',$bRevert) ;
			$aWebpage->SetBodyView($aView);
		}
		
		$aWebpage->ShowView() ;		
	}

}

?>