<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 控制器类 W3B_InstalledExtensionList
 *
 * @access public
 */
class Ext_JCSystem_PlatformExtensions extends W3B_Controller 
{
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_PlatformExtensions(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_IExtensionSetup::MSG_EXECUTED) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_IExtensionSetup::MSG_FAILED) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_IExtensionSetup::MSG_SUCCEED) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
		
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('全平台扩展管理','Ext_JCSystem',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @param	$arrArg=array	array	参数 
	 * @return	void
	 */
	public function MainRun()
	{
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($this->GetService(),$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
	
		// 认证
		if( !$aFrame->Authorize($this->GetService()->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return  ;
		}
		
		$this->DoAction() ;
		
		// 载入扩展清单
		$arrExtLst = $this->LoadInstalledExtensions() ;
		
		// 显示扩展清单
		$aView = new JCAT_ViewHtml('template.Ext_JCSystem_ViewPlatformExtensions.html',$this) ;
		
		$aView->SetViewVar('arrExtLst',$arrExtLst) ;
		
		//$aView->ShowView() ;
		$aFrame->RenderFrame($aView);
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ActionUnsetup()
	{
		$aRequest = $this->GetRequest() ;
		$bCompletely = $aRequest->GetParam('bCompletely')? true: false ;
		$aPlatform = $this->GetPlatform() ;
		$arrUnsetupExts = $this->GetUnsetupExts($aPlatform->GetExtensionManager()) ;
		
		foreach ($arrUnsetupExts as $sExtNames)
		{
			if( !W3B_UnsetupExtension::UnsetupExtension($sExtNames,$bCompletely) )
			{
				break ;
			}
		}
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ActionDisable()
	{
		$aService = $this->GetService() ;
		$arrUnsetupExts = $this->GetUnsetupExts($aService->GetExtensionManager(),true) ;
		
		foreach ($arrUnsetupExts as $sExtName)
		{
			W3B_EnableExtension::EnableExtension($aService,$sExtName,false) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ActionEnable()
	{
		$aService = $this->GetService() ;
		$aSrvExtMgr = $aService->GetExtensionManager() ;
		$aSrvExtTree = $aSrvExtMgr->GetExtensionDependenceTree() ;
		
		$aPlatform = $this->GetPlatform() ;
		$aExtMgr = $aPlatform->GetExtensionManager() ;
		$aExtTree = $aExtMgr->GetExtensionDependenceTree() ;
		$arrExts = $this->GetUnsetupExts($aExtMgr,false) ;
		
		foreach ($arrExts as $sExtName)
		{
			if( $aSrvExtTree->GetDependenceItem($sExtName) )
			{
				continue ;
			}
			
			$aDependItem = $aExtTree->GetDependenceItem($sExtName) ;
			$aExtInfo = $aDependItem->GetAttachment() ;
			JCAT_ASSERT::ASSERT_INSTANCE($aExtInfo,'W3B_IExtensionInfo') ;
			
			W3B_EnableExtension::EnableExtension($aService,$sExtName,true) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function ActionUploadPackage()
	{
		$aRequest = $this->GetRequest() ;
		$arrPackage = $aRequest->GetParam('sPackage') ;

		if( !$arrPackage['tmp_name'] )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 sPackage','Ext_JCSystem',null),MSGMVC_BAD) ;
			return ;
		}

		$aSetup = new W3B_SetupExtensionPackage() ;
		$aSetup->SetPlatform($this->GetPlatform());
		
		$aSetupRequest = new JCAT_Request(JCAT_Request::TYPE_CUS) ;
		$aSetupRequest->SetParam('sExtPackage',$arrPackage['tmp_name']) ;
		$aSetup->SetRequest($aSetupRequest) ;
		
		$aSetup->MainRun() ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	array
	 */
	public function GetUnsetupExts(W3B_ExtensionManager $aExtensionManager,$bRevert=true)
	{
		$aRequest = $this->GetRequest() ;
		$arrExtNames = $aRequest->GetParam('arrExtNames') ;
		
		JCAT_ASSERT::ASSERT_NOTNULL($arrExtNames,JCAT_Language::SentenceEx('缺少参数 arrExtNames','Ext_JCSystem',null));
		JCAT_ASSERT::ASSERT_ISTHESE($arrExtNames,array('array:string'),JCAT_Language::SentenceEx('参数 arrExtNames 必须为字符串数组','Ext_JCSystem',null));
		
		$arrUnsetupExts = array() ;
		foreach($arrExtNames as $sExtNames)
		{
			$aReverseDependIter = $aExtensionManager->CreateExtensionDependenceIterator($sExtNames, $bRevert, 0) ;
			
			if(!$aReverseDependIter)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('指定的扩展（%s）不存在，无法完成操作。','Ext_JCSystem',null,$sExtNames),MSGMVC_BAD) ;
				continue ;
			}

			for ( $aReverseDependIter->First(); !$aReverseDependIter->IsDone(); $aReverseDependIter->Next() )
			{
				$aExtDependItem = $aReverseDependIter->Current() ;				
				$arrUnsetupExts[] = $aExtDependItem->GetItemName() ;
			}
			$arrUnsetupExts[] = $sExtNames ;
		}
		
		$arrUnsetupExts = array_unique($arrUnsetupExts) ;
		
		return $arrUnsetupExts ;
	}
	
	
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	array
	 */
	private function LoadInstalledExtensions()
	{
		$aPlatform = $this->GetPlatform() ;
		$aExtMgr = $aPlatform->GetExtensionManager() ;
		
		$aSvrExtMgr = $this->GetService()->GetExtensionManager() ;

		$aIterator = $aExtMgr->GetExtensionDependenceTree()->CreateDependItemIter() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aItem = $aIterator->Current();
			$aExtInfo = $aItem->GetAttachment() ;

			if($aExtInfo)
			{
				JCAT_ASSERT::ASSERT_INSTANCE($aExtInfo,'W3B_IExtensionInfo');
				$arrExts[] = $aExtInfo ;
				
				// 是否在当前服务已经启用
				if( $aSvrExtMgr->GetLoadedExtension($aExtInfo->GetName()) )
				{
					$aExtInfo->SetInfo('bEnable',true) ;
					$aExtInfo->SetInfo('sCSSClass','Ext_JCSystem_PlatformExtensions_Enable') ;
				}
				else
				{
					$aExtInfo->SetInfo('sCSSClass','Ext_JCSystem_PlatformExtensions_Disable') ;
				}
			}
		}

		return $arrExts ;
	}

}

?>