<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCSystem_ApplyPatch 
 *
 * @access public
 */
class Ext_JCSystem_ApplyPatch
	extends W3B_Controller 
{
	const VIEW_FORM = 'theViewForm' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_ApplyPatch(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtmlForm('template.Ext_JCSystem_ViewApplyPatch.html',$this) ;
		$this->AddView($aView,self::VIEW_FORM) ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		// 框架菜单
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('应用补丁','Ext_JCSystem',null)
		) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aView = $this->GetView(self::VIEW_FORM) ;
	
		// 认证
		$aService = $this->GetService() ;
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return  ;
		}
		
		do{			
			if( !$aView->IsSubmitingForm() )
			{
				break ;
			}
			
			$aRequest = $this->GetRequest() ;
			
			$arrFile = $aRequest->GetParam('filePatch') ;
			if(!$arrFile)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('请上传补丁文件。','Ext_JCSystem',null),MSGMVC_BAD) ;
				break ;
			}
			
			try{
				
				$sPatchPath = $arrFile['tmp_name'] ;
				$aPlatform = $this->GetPlatform() ;
				
				// 载入补丁
				$aPatch = new W3B_Patch() ;
				$arrChangeList = $aPatch->ApplyPatch($sPatchPath,$aPlatform) ;
				
				// 清除平台中的缓存文件
				$aPlatform = $this->GetPlatform() ;
				$arrCaches[] = $aPlatform->GetPlatformPath().'/Classes/ClassesPath.serialize' ;
				$arrCaches[] = JCATPATH.'Lib.php/ClassesPath.serialize' ;
				$arrCaches[] = $aPlatform->GetPlatformPath().'/Resource/UITemplate/inc.TemplateFileIndex.php' ;
				foreach ($arrCaches as $sCache)
				{
					if(!is_file($sCache))
					{
						continue ;
					}
					
					unlink ($sCache)  ;
					if( is_file($sCache) )
					{
						new JCAT_Message(JCAT_Language::SentenceEx('清除系统缓存文件失败，请手工删除此文件: %s。','Ext_JCSystem',null,$sCache),MSGMVC_BAD) ;
					}
					
					else 
					{
						new JCAT_Message(JCAT_Language::SentenceEx('已经清除系统缓存文件: %s。','Ext_JCSystem',null,$sCache),MSGMVC_OK) ;
					}
				}

				new JCAT_Message(implode("<br />\r\n",$arrChangeList),MSGMVC_OK) ;
				new JCAT_Message(JCAT_Language::SentenceEx('升级完成。','Ext_JCSystem',null),MSGMVC_OK) ;
				
				$aView->ShowForm(false) ;

			}
			catch (JCAT_Exception $e)
			{
				new JCAT_Message('升级失败：'.$e->GetMsg(),MSGMVC_BAD) ;
				break ;
			}
			
			
			
		} while (0) ;
	
		$aFrame->RenderFrame($aView) ;
	}
	
}

?>