<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCSystem_ApplyPatch 
 *
 * @access public
 */
class Ext_JCSystem_BuildPatch
	extends W3B_Controller 
{
	const VIEW_FORM = 'theViewForm' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_BuildPatch(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtmlForm('template.Ext_JCSystem_ViewBuildPatch.html',$this) ;
		$this->AddView($aView,self::VIEW_FORM) ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		// 框架菜单
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('创建补丁','Ext_JCSystem',null)
		) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aView = $this->GetView(self::VIEW_FORM) ;
	
		// 认证
		$aService = $this->GetService() ;
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		if( $aView->IsSubmitingForm() and $aFromVersion=$this->CheckFromVersion())
		{			
			// 取得输入
			$aRequest = $this->GetRequest() ;
			$arrFileFramework = $aRequest->GetParam('filePatchFramework') ;
			$arrFilePlatform = $aRequest->GetParam('filePatchPlatform') ;
			$aPatchFramework = $arrFileFramework['tmp_name']? JCAT_String::CreateFromFile($arrFileFramework['tmp_name']): null ;
			$aPatchPlatform = $arrFilePlatform['tmp_name']? JCAT_String::CreateFromFile($arrFilePlatform['tmp_name']): null ;
			
			// 生成输出文件
			$aExtensionManager = $aService->GetExtensionManager() ;
			$aExtension = $aExtensionManager->GetLoadedExtension('Ext_JCSystem') ;
			$sOutput = $aExtension->GetDefaultTempDirectory() . '/' . microtime(true) ;
			
			try {
				
				// 创建补丁
				$aPatch = new W3B_Patch() ;
				$aPatch->MakePatch($this->GetPlatform(),$aFromVersion,$sOutput,$aPatchPlatform,$aPatchFramework) ;
				
				if(is_file($sOutput))
				{
					new JCAT_Message(JCAT_Language::SentenceEx('补丁文件创建成功。','Ext_JCSystem',null),MSGMVC_OK) ;
					new JCAT_Message(JCAT_Language::SentenceEx(
							'<a href="%s">下载补丁</a>'
							,'Ext_JCSystem',null
							, JCAT_DownloadFile::GetHTTPAccessPath($sOutput)
					),MSGMVC) ;
				}
				
				else 
				{
					new JCAT_Message(JCAT_Language::SentenceEx('补丁文件创建失败。','Ext_JCSystem',null),MSGMVC_BAD) ;
				}
				
			}
			catch (Exception $e)
			{
				new JCAT_Message(JCAT_Language::SentenceEx('补丁文件创建失败: %s。','Ext_JCSystem',null,$e->getMessage()),MSGMVC_BAD) ;
			}
			
			$aView->ShowForm(false) ;
		}
		else 
		{
			$aView->ShowForm(true) ;
		}
	
		$aFrame->RenderFrame($aView) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	JCAT_Version
	 */
	private function CheckFromVersion()
	{
		$aRequest = $this->GetRequest() ;
		$sFromVersion = $aRequest->GetParam('fromVersion') ;
		
		if( !JCAT_Version::VerifyFormat($sFromVersion) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('请输入一个有效的版本号: %s。','Ext_JCSystem',null,$sFromVersion),MSGMVC_BAD) ;
			return null ;
		}
		
		$aFromVersion = JCAT_Version::FromString($aRequest->GetParam('fromVersion')) ;
		
		$aPlatformVersion = $this->GetPlatform()->GetVersion() ;
		if( $aPlatformVersion->Compare($aFromVersion)<=0 )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('起始版本号(%s)必须低于完成版本号(%s)。','Ext_JCSystem',null,$sFromVersion,$aPlatformVersion),MSGMVC_BAD) ;
			return null ;
		}

		return $aFromVersion ;
	}
}

?>