<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class Ext_JCSystem_PatchFile
{
	const FILE_FLAG = 'W3B.PATCH' ;
	const PATCH_VERSION = '00.01.00.20090509' ;
	
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function Ext_JCSystem_PatchFile()
	{
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sOutputPath
	 * @param	$sFrameworkPatchPath
	 * @param	$sPlatformPatchPath
	 * @param	$nCompressLevel=0
	 * @static
	 * @return	void
	 */
	static public function BuildPath($sOutputPath,$sFrameworkPatchPath=null,$sPlatformPatchPath=null,$nCompressLevel=0)
	{
		JCAT_ASSERT::ASSERT_INRANGE($nCompressLevel,0,9)  ;
		if( $nCompressLevel>0 and !function_exists('gzcompress') )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法使用压缩选项，当前服务器没有安装 PHP ZLib 模块。', 'Ext_JCSystem', null
			)) ;
		}
		
		if( $sPlatformPatchPath and !is_file($sPlatformPatchPath) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法读取文件：%s', 'Ext_JCSystem', null, $sPlatformPatchPath
			)) ;
		}
		if( $sFrameworkPatchPath and !is_file($sFrameworkPatchPath) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法读取文件：%s', 'Ext_JCSystem', null, $sFrameworkPatchPath
			)) ;
		}
		
		// 读取并使用压缩选项
		$sFrameworkPatch = $sFrameworkPatchPath? file_get_contents($sFrameworkPatchPath): '' ;
		$sPlatformPatch = $sPlatformPatchPath? file_get_contents($sPlatformPatchPath): '' ;
		if($nCompressLevel>0)
		{
			$sFrameworkPatch = $sFrameworkPatch? gzcompress($sFrameworkPatch,$nCompressLevel): '' ;
			$sPlatformPatch = $sPlatformPatch? gzcompress($sPlatformPatch,$nCompressLevel): '' ;
		}
		
		// 创建文件头的信息 
		$sFlagLen = strlen(self::FILE_FLAG) ;
		$sVerLen = strlen(self::PATCH_VERSION) ;

		$sHeader = pack("A{$sFlagLen}A{$sVerLen}LLLL"
				, self::FILE_FLAG
				, self::PATCH_VERSION
				, strlen($sFrameworkPatch)
				, $nCompressLevel
				, strlen($sPlatformPatch)
				, $nCompressLevel
		) ;
		
		// 保存文件
		if( !file_put_contents($sOutputPath,$sHeader.$sFrameworkPatch.$sPlatformPatch) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法写入文件:%s'
				, 'Ext_JCSystem', null
				, $sOutputPath
			)) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sPatchPath
	 * @return	void
	 */
	public function Load($sPatchPath)
	{
		if( !is_file($sPatchPath) )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'补丁文件不存在：%s', 'Ext_JCSystem', null, $sPatchPath
			)) ;
		}
		
		$aPatchContent = JCAT_String::CreateFromFile($sPatchPath) ;
		
		// 读取文件头
		// ===============================================
		$sFlagLen = strlen(self::FILE_FLAG) ;
		$sVersionLen = strlen(self::PATCH_VERSION) ;
		
		$arrHeader = unpack("A{$sFlagLen}a/A{$sVersionLen}b/Lc/Ld/Le/Lf",$aPatchContent->GetSource()) ;
		$sFlag = $arrHeader['a'] ;
		$sVersion = $arrHeader['b'] ;
		$nFrameworkLen = $arrHeader['c'] ;
		$nFrameworkCompressLevel = $arrHeader['d'] ;
		$nPlatformLen = $arrHeader['e'] ;
		$nPlatformCompressLevel = $arrHeader['f'] ;
	
		// 检查文件头标记
		if( $sFlag!=self::FILE_FLAG )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'这不是一个补丁文件：%s', 'Ext_JCSystem', null, $sPatchPath
			)) ;
		}
		
		// 检查文件版本
		if( $sVersion!=self::PATCH_VERSION )
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'无法支持补丁文件的版本：%s; 支持的版本号为：%s', 'Ext_JCSystem'
				, null, $sVersion, self::PATCH_VERSION
			)) ;
		}
		
		// 检查压缩选项
		if( ($nFrameworkCompressLevel>0 or $nPlatformCompressLevel>0) and !function_exists('gzuncompress') ) 
		{
			throw new JCAT_Exception(JCAT_Language::SentenceEx(
				'这是一个经过压缩的补丁文件，当前服务器运行环境没有安装PHP的压缩模块（ZLib），无法解压缩补丁文件。', 'Ext_JCSystem', null
			)) ;
		}
		
		// 文件头的长度, 16 是 4个 L(long 4 byte)类型的长度
		$nHeaderLen = $sFlagLen + $sVersionLen + 16 ; 
		
		// 为 framework 创建补丁对象
		if($nFrameworkLen>0)
		{
			$sPatch4Framework = $aPatchContent->SubStr($nHeaderLen,$nFrameworkLen) ;
			
			if($nFrameworkCompressLevel>0)
			{
				$sPatch4Framework = gzuncompress($sPatch4Framework) ;
			}
			
			$this->aPatchFramework = new JCAT_Patch() ;
			$this->aPatchFramework->LoadPatch(new JCAT_String($sPatch4Framework)) ;
		}
		else
		{
			$this->aPatchFramework = null ;
		}
		
		// 为 platform 创建补丁对象
		if($nPlatformLen>0)
		{
			$sPatch4Platform = substr($aPatchContent,$nHeaderLen+$nFrameworkLen) ;
			
			if($nPlatformCompressLevel>0)
			{
				$sPatch4Platform = gzuncompress($sPatch4Platform) ;
			}
			
			$this->aPatchPlatform = new JCAT_Patch() ;
			$this->aPatchPlatform->LoadPatch(new JCAT_String($sPatch4Platform)) ;
		}
		else
		{
			$this->aPatchPlatform = null ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function Test($sApplyPath,&$aUnaccessFiles)
	{
		$bChangable = true ;
		
		if( $this->aPatchFramework )
		{
			$aUnaccessFiles4ThisPatch =array() ;
			if( !$this->aPatchFramework->TestAccessMode($sApplyPath,$aUnaccessFiles4ThisPatch) )
			{
				$bChangable = false ;
			}
			
			$aUnaccessFiles = array_merge($aUnaccessFiles,$aUnaccessFiles4ThisPatch) ;
		}
		
		if( $this->aPatchPlatform )
		{
			$aUnaccessFiles4ThisPatch =array() ;
			if( !$this->aPatchPlatform->TestAccessMode($sApplyPath,$aUnaccessFiles4ThisPatch) )
			{
				$bChangable = false ;
			}
			
			$aUnaccessFiles = array_merge($aUnaccessFiles,$aUnaccessFiles4ThisPatch) ;
		}
		
		
		return $bChangable ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sApplyPath
	 * @return	void
	 */
	public function Apply($sApplyPath)
	{
		if( $this->aPatchFramework )
		{
			$this->aPatchFramework->Apply($sApplyPath.'/JCAT0.4/');
		}
		
		if( $this->aPatchPlatform )
		{
			$this->aPatchPlatform->Apply($sApplyPath);
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreateChangingFileIter()
	{
		$arrChangingFiles = array() ;
		
		if( $this->aPatchFramework )
		{
			$arrChangingFiles[] = $this->aPatchFramework->CreateChangingFileIter() ;
		}
		
		if( $this->aPatchPlatform )
		{
			$arrChangingFiles[] = $this->aPatchPlatform->CreateChangingFileIter() ;
		}
		
		return new JCAT_MultiIterator($arrChangingFiles) ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Patch
	 */
	private $aPatchFramework ;
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		JCAT_Patch
	 */
	private $aPatchPlatform ;
}

?>