<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCSystem_ApplyPatch 
 *
 * @access public
 */
class Ext_JCSystem_SMTPSetting extends W3B_Controller 
{
	const VIEW_FORM = 'VIEW_FORM' ;
	const MODEL = 'MODEL' ;

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_STMPSetting(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 
		$aModel = new JCAT_PreferenceModel($this->GetPlatform()->GetPreference()) ;
		$aModel->SetItem('/Platform/Resource/SMTP','SMTPServer','SMTPServer');
		$aModel->SetItem('/Platform/Resource/SMTP','SMTPPort','SMTPPort');
		$aModel->SetItem('/Platform/Resource/SMTP','SMTPSecure','SMTPSecure');
		$aModel->SetItem('/Platform/Resource/SMTP','SMTPUser','SMTPUser');
		$aModel->SetItem('/Platform/Resource/SMTP','SMTPPassword','SMTPPassword');
		$aModel->SetItem('/Platform/Resource/SMTP','Reply','Reply');
		$aModel->SetItem('/Platform/Resource/SMTP','AuthorAddress','AuthorAddress');
		$aModel->SetItem('/Platform/Resource/SMTP','AuthorName','AuthorName');
		$this->AddModel($aModel,self::MODEL) ;
		
		
		// 创建并加载视图：
		$aView = new Ext_JCSystem_SMTPSettingView($this) ;
		$this->AddView($aView,self::VIEW_FORM) ;
		$aView->SetModel($aModel) ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		// 框架菜单
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('设置SMTP','Ext_JCSystem',null)
		) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aView = $this->GetView(self::VIEW_FORM) ;
	
		// 认证
		$aService = $this->GetService() ;
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aService->GetIdManager()) )
		{
		    $aFrame->DenyAccess() ;
		    return  ;
		}
		
		$aView->ExchangeData(JCAT_IViewForm::DOC_TO_UICTRL) ;
		
		if( $aView->IsSubmitingForm() and $aView->VerifyData() )
		{
			$aView->SetDataFromSubmited() ;
			$aView->ExchangeData(JCAT_IViewForm::UICTRL_TO_DOC) ;
			
			$aModel = $aView->GetModel() ;
			if( $aModel->Save() )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('设置已经保存','Ext_JCSystem',null),MSGMVC_OK) ;
			}
			else 
			{
				new JCAT_Message(JCAT_Language::SentenceEx('系统在保存设置时遇到了错误。','Ext_JCSystem',null),MSGMVC_BAD) ;
			}
			
			$aView->ShowForm(false) ;
		}
		
			
	
		$aFrame->RenderFrame($aView) ;
	}
	
}

?>