<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCPlatforManager_CreateNewServier 
 *
 * @access public
 */
class Ext_JCSystem_AdminServiceList
	extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_AdminServiceList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 文档
		$aModel = new W3B_AggModelService(true) ;
		$this->AddModel($aModel,'theServiceListModel') ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtml('template.Ext_JCSystem_ViewAdminServiceList.html',$this,'theView') ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,'theServiceListView') ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		
		// 框架菜单
		$this->InitializeFrameMenuPath() ;
	}

	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(
				Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
				, JCAT_Language::SentenceEx('服务管理','Ext_JCSystem',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return false ;
		}
		
		// 执行操作
		$this->DoActionCreateNewDoname() ;
		$this->DoActionDeleteService() ;
		$this->DoActionDeleteDoname() ;
		$this->DoActionEnableService() ;
		
		
		$aModel = $this->GetModel('theServiceListModel') ;
		$aView = $this->GetView('theServiceListView') ;
	
		$aModel->Load() ;
		
		$aFrame->RenderFrame($aView) ;
	}
	
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function DoActionCreateNewDoname()
	{
		$aUserRequest = $this->GetRequest() ;
		if( !$aUserRequest->GetParam('action') or $aUserRequest->GetParam('action')!='CreateNewDoname' )
		{
			return ;
		}
		
		// 检查域名
		$sDoname = $aUserRequest->GetParam('sDoname') ;
		$sDoname = strtolower($sDoname) ;
		if( !W3B_ModelServiceDoname::VerifyDonameFormat($sDoname) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('设置的域名无效：%s','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
			return ;
		}
		
		// 检查服务id
		$nServiceId = $aUserRequest->GetParam('nForServiceId') ;
		if( !is_numeric($nServiceId) or $nServiceId<1 )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nForServiceId，或参数无效','Ext_JCSystem',null),MSGMVC_BAD) ;
			return ;
		}
		
		// 检查域名是否存在
		if( W3B_ModelServiceDoname::HasDonameExists($sDoname) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('非常抱歉，域名：%s 已经被占用。','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
			return ;
		}
		
		$aServiceDoname = new W3B_ModelServiceDoname() ;
		$aServiceDoname->Set('nServiceId',$nServiceId) ;
		$aServiceDoname->Set('sServiceDoname',$sDoname) ;
		
		if( $aServiceDoname->Serialize() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('已经为服务添加访问域名：%s 。','Ext_JCSystem',null,$sDoname),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法保存域名：%s。','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
		}
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function DoActionDeleteDoname()
	{
		$aUserRequest = $this->GetRequest() ;
		if( !$aUserRequest->GetParam('action') or $aUserRequest->GetParam('action')!='DeleteDoname' )
		{
			return ;
		}
		
		$sDoname = $aUserRequest->GetParam('sServiceDoname') ;
		$sDoname = strtolower($sDoname) ;
		
		$aServiceDoname = new W3B_ModelServiceDoname() ;
		$aServiceDoname->FindBy('sServiceDoname',$sDoname) ;
		if( !$aServiceDoname->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('指定删除的域名并不存在：%s','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
			return ;
		}
		
		// 检查是否当前正在访问的域名
		if( strtolower($this->GetRequest()->GetParam('HTTP_HOST'))==$sDoname )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('抱歉，你不能删除正在访问的域名。','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
			return ;
		}
		
		if( $aServiceDoname->Delete() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('域名已经删除：%s','Ext_JCSystem',null,$sDoname),MSGMVC_OK) ;
			return ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('删除域名失败：%s','Ext_JCSystem',null,$sDoname),MSGMVC_BAD) ;
			return ;
		}
	}
	
	private function DoActionEnableService()
	{
		$aUserRequest = $this->GetRequest() ;
		if( !$aUserRequest->GetParam('action') or $aUserRequest->GetParam('action')!='EnableService' )
		{
			return ;
		}
		
		// 检查 change
		$sChange = $aUserRequest->GetParam('change') ;
		if( !in_array($sChange,array('1','0')) )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 change，或参数无效','Ext_JCSystem',null),MSGMVC_BAD) ;
			return ;
		}
	
		// 检查服务id
		$nServiceId = $aUserRequest->GetParam('nForServiceId') ;
		if( !is_numeric($nServiceId) or $nServiceId<1 )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('缺少参数 nForServiceId，或参数无效','Ext_JCSystem',null),MSGMVC_BAD) ;
			return ;
		}
		$nServiceId = intval($nServiceId) ;
		
		$aService = $this->GetService() ;
		if( $aService->GetServiceId() == $nServiceId )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法当前服务的状态。','Ext_JCSystem',null),MSGMVC_BAD) ;
			return ;
		}
		
		$aForService = new W3B_ModelService() ;
		$aForService->FindById($nServiceId) ;
		if( !$aForService->Load() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('无法找到指定的服务（ID: %s）。','Ext_JCSystem',null,$nServiceId),MSGMVC_BAD) ;
			return ;
		}
		
		$aForService->Set('bEnable',$sChange) ;
		$sWhat = ($sChange=='1')? '开启': '关闭' ;
		if( $aForService->Serialize() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx("服务已经{$sWhat}。",'Ext_JCSystem',null),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx("{$sWhat}服务失败。",'Ext_JCSystem',null),MSGMVC_BAD) ;
		}
	}
	
	
	private function DoActionDeleteService()
	{
		$aRequest = $this->GetRequest() ;
		if( !$aRequest->GetParam('action') or $aRequest->GetParam('action')!='DeleteService' )
		{
			return ;
		}
		
		$aDeleteController = W3B_Controller::CreateController('W3B_DeleteService',$this->GetService()) ;
		$aDeleteController->MainRun() ;
	}
	
}

?>