<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCSystem_CreateNewServier 
 *
 * @access public
 */
class Ext_JCSystem_BuildInstalledExtensionDB
	extends W3B_Controller 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_BuildInstalledExtensionDB(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 创建并加载视图：
		$aView = new JCAT_ViewHtml('template.Ext_JCSystem_BuildInstalledExtensionDB.html',$this,'theView') ;
		$this->AddView($aView,'theView') ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('整理扩展','Ext_JCSystem',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return false ;
		}
		
		$aView = $this->GetView('theView') ;
	
		
		// 将当前安装的扩展整理到 数据库 
		// ---------------------------------------------------------
		$aService = $this->GetService() ;
		$aIter = $aService->GetExtensionManager()->CreateLoadedExtensionIterator() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aExt = $aIter->Current();		
			self::InsertExt($aExt) ;
		}

		
		$aFrame->RenderFrame($aView) ;
	}
	

	static public function InsertExt(W3B_IExtension $aExtension)
	{
		
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		$aExtentionInfo = $aExtension->GetExtensionInfo() ;
	
		$aVersion = $aExtentionInfo->GetVersion() ;
		$aCompatibleVersion = $aExtentionInfo->GetCompatibleVersions() ;
		
		$arrDepends = array() ;
		$aDependIter = $aExtentionInfo->CreateDependenceIterator() ;
		for ( $aDependIter->First(); !$aDependIter->IsDone(); $aDependIter->Next() )
		{
			$arrDepends[] = $aDependIter->Current();
		}
		$sExtName = get_class($aExtension) ;
	
		try{
			$aDB->Insert('W3B_InstalledExtension',array(
				'sExtName' => $sExtName
				, 'nExtVersion' => $aVersion->Get32Integer()
				, 'sExtVersionCode' => $aVersion->GetVersionCode()
				, 'bAbstract' => $aExtentionInfo->IsAbstract()? '1': '0'
				, 'sExtTitle' => $aExtentionInfo->GetTitle()
				, 'sExtDescription' => $aExtentionInfo->GetDescription()
				, 'sExtCompatibleVersions' => $aCompatibleVersion->MakeString()
				, 'sDependencies' => implode("\r\n",$arrDepends)
			)) ;
		}
		catch (Exception $e)
		{
			new JCAT_Message(
					JCAT_Language::SentenceEx('无法将扩展(%s)写入数据库：%s','Ext_JCSystem',null
					, $sExtName, $e->getMessage()), MSGMVC_BAD) ;
			return false ;
		}
		
		// 
		$aPreference = W3B_Platform::GetPreference() ;
		$aKey = $aPreference->CreateKey("/Extensions/{$sExtName}") ;
		$aKey->SetItem('sVersion',$aVersion->toString(true)) ;
		$aKey->Save() ;
		
		
		new JCAT_Message(
				JCAT_Language::SentenceEx('已经将扩展(%s)写入数据库.','Ext_JCSystem',null, $sExtName ),MSGMVC_OK) ; 
		
		return true ;
	}
	
}

?>