<?php 
/**
 * ... ...
 * ... ...
 *
 */ 

/**
 * 控制器类 Ext_JCSystem_CreateNewServier 
 *
 * @access public
 */
class Ext_JCSystem_CreateNewService
	extends W3B_CreateNewService 
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCSystem_CreateNewService(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(get_class($this),$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		parent::Initialize() ;
		
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,W3B_Service::MSG_SERVICE_BAD) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;
		$this->SetMessageQueue($aMessageQueue) ;
		
		// 创建并加载视图：
		$aView = new Ext_JCSystem_ViewServiceForm($this) ;
		$this->AddView($aView,'theViewServiceForm') ;
		
		// 认证
		$aAuthenticator = Ext_JCSystem::CreateAuthenticator() ;
		$this->SetAuthenticator($aAuthenticator) ;
		
		// 设置锁定扩展
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam('arrLockedExtensions',array('Ext_JCUser')) ;
		
		// 框架菜单
		$this->InitializeFrameMenuPath() ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('创建新服务','Ext_JCSystem',null)
		) ;
	}
	
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;
		$aRequest = $this->GetRequest() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return null ;
		}
		
		$aView = $this->GetView('theViewServiceForm') ;
		
		// create extension tree
		//$aExts = new W3B_AggModelInstalledExt() ;
		//$aExts->Load() ;
		$aPlatform = $this->GetPlatform() ;
		$aExtTree = $aPlatform->GetExtensionManager()->GetExtensionDependenceTree() ;
		
		// load extentsion
		$arrSelectedExtensions = $aRequest->GetParam('arrSelectedExtensions') ;
		if(!$arrSelectedExtensions)
		{
			$arrSelectedExtensions = array() ;
		}
		
		$arrLockedExtensions = $aRequest->GetParam('arrLockedExtensions') ;
		
		$aView->LoadExtensions($aExtTree,$arrSelectedExtensions,$arrLockedExtensions) ;

		// 提交表单视图
		$aNewService = null ;
		do{
			if( !$aView->IsSubmitingForm() ) 
			{
				break ;
			}
			
			$aView->SetDataFromSubmited() ;
	
			// 用户输入校验
			if( !$aView->VerifyData() )
			{
				break ;
			}
		
			// 检查重复 用户名
			$sAdminUsername = $aView->GetUICtrlExchangeData('Administrator') ;
			if( $sAdminUsername and Ext_JCUser_Model::IsUserExists($sAdminUsername) )
			{
				new JCAT_Message(JCAT_Language::SentenceEx('对不起，用户名“%s”已经被占用;你不能使用这个用户名。','Ext_JCSystem',null,$sAdminUsername),MSGMVC_BAD) ;
				break ;
			}
			
			// 
			$sDomainName = $aView->GetUICtrlExchangeData('DomainName') ;
			$aRequest->SetParam('sDoname',$sDomainName);
			$aNewService = parent::MainRun() ;
			if( !$aNewService )
			{
				break ;
			}
			
			// 启用扩展
			// --------------------------
			$this->EnableExtensions($aNewService,$aExtTree) ;
			

			// 创建用户
			if($sAdminUsername)
			{
				if( $this->CreateAdministrator($aNewService->GetServiceId()) )
				{
					break ;
				}
			}
			
			// 完成
			$aView->ShowForm(false) ;
		
		} while (0) ;

		
		$aFrame->RenderFrame($aView) ;
		return $aNewService ;
	}
	
	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function CreateAdministrator($nServiceId)
	{
		$aView = $this->GetView('theViewServiceForm') ;
		$sAdminUsername = $aView->GetUICtrlExchangeData('Administrator') ;		
		$sPassword = $aView->GetUICtrlExchangeData('Password') ;
		
		$aNewId = new Ext_JCUser_Identity() ;
		$sPassword = $aNewId->EncodePassword($sPassword) ;
		
		// 用户模型
		$aNewUserModel = $aNewId->GetModel() ;
		$aNewUserModel->Set('sUserName',$sAdminUsername) ;
		$aNewUserModel->Set('sPassword',$sPassword) ;
		
		if( $aNewUserModel->Serialize() )
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建新用户：%s','Ext_JCSystem',null,$sAdminUsername),MSGMVC_OK) ;
		}
		
		else 
		{
			new JCAT_Message(JCAT_Language::SentenceEx('创建用户：%s 失败。','Ext_JCSystem',null,$sAdminUsername),MSGMVC_BAD) ;
			return ;
		}
		
		// 设置权限
		if( $aNewUserModel->AddPurview(
				Ext_JCUser::SERVICE_ADMIN
				, Ext_JCUser::SERVICE_ADMIN_DOMAIN
				, $nServiceId ) )
		{
			 new JCAT_Message(JCAT_Language::SentenceEx('已经将用户设置为管理员：%s','Ext_JCSystem',null,$sAdminUsername),MSGMVC_OK) ;
		}
		
		else
		{
			new JCAT_Message(JCAT_Language::SentenceEx('用户管理员权限分配失败：%s ','Ext_JCSystem',null,$sAdminUsername),MSGMVC_BAD) ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @param	$Parameter
	 * @return	void
	 */
	private function EnableExtensions(W3B_Service $aNewService,W3B_DependenceTree $aExtTree)
	{		
		$arrExtentsions = array() ;
		
		// 锁定的扩展
		$aRequest = $this->GetRequest() ;
		$arrLockedExtensions = $aRequest->GetParam('arrLockedExtensions') ;
		if( is_array($arrLockedExtensions) )
		{
			foreach ($arrLockedExtensions as $aLockedExtName)
			{
				$aLockedExtItem = $aExtTree->GetDependenceItem($aLockedExtName) ;
				$aIterator = $aLockedExtItem->CreateDependenceIterator() ;
				for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
				{
					$aDependItem = $aIterator->Current();
					$sItemName = $aDependItem->GetItemName() ;
					if (W3B_ExtensionManager::PLATFORM_DEPENDNAME!=$sItemName)
					{
						$arrExtentsions[] = $sItemName ;
					}
				}
				
				$arrExtentsions[] = $aLockedExtName ;
			}
		}
		
		// 用户提交的扩展
		$aView = $this->GetView('theViewServiceForm') ;
		$arrSubmitExtentsions = $aView->GetUICtrlExchangeData('ExtensionSelect') ;
		if (is_array($arrSubmitExtentsions))
		{
			$arrExtentsions = array_merge($arrExtentsions,$arrSubmitExtentsions) ;
		}
		
		//$aExtTree
		
		$aService = $this->GetService() ;
		$aPlatform = $aService->GetPlatform() ;
		
		// 为每个扩展创建 依赖项对象
		$arrExtDependItems = array() ;
		foreach ($arrExtentsions as $sExtName)
		{
			$sExtVersion = $aPlatform->GetExtensionVersion($sExtName) ;
			$aExtInfo = W3B_ExtensionInfo::GetInstance($sExtName,$sExtVersion) ;
			
			// 为此扩展创建依赖项
			$aDependItem = new W3B_DependenceItem($sExtName,$aExtInfo->GetCompatibleVersions(),$aExtInfo->GetVersion()) ;
			$aDependItem->Attach($aExtInfo) ;
			
			$arrExtDependItems[$sExtName] = array( $aDependItem, $aExtInfo->CreateDependenceIterator() ) ;
		}
		
		// 创建并加入到依赖树
		$aTree = new W3B_DependenceTree() ;
		$aPlatformDependItem = $aPlatform->CreateDependenceItem() ;
		$aTree->AppendItem( $aPlatformDependItem, new JCAT_NullIterator() );
		$aTree->AppendItemsFromArray($arrExtDependItems) ;

		// 
		$aIter = $aTree->CreateDependItemIter() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aDependItem = $aIter->Current() ;
			
			if( $aDependItem==$aPlatformDependItem )
			{
				continue ;
			}
			$aExtInfo = $aDependItem->GetAttachment() ;
			
			W3B_EnableExtension::EnableExtension($aNewService,$aDependItem->GetItemName(),true,$aExtInfo->GetPriorityLevel()) ;
		}
	}

	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function LoadInstalledExtension(Ext_JCSystem_ViewServiceForm $aView,array $arrSelectedExts=array(),array $arrLockedExts=array())
	{		
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_AggModelInstalledExt
	 */
	private $aExtsTree ;
}

?>