<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class Ext_JCSystem_ExtensionSelect extends JCAT_UICtrlHtmlMBox
{
	/**
	 * 构造函数
	 *
	 * @access	public
	 * @return	void
	 */
	public function Ext_JCSystem_ExtensionSelect( $sName, $sUIName='' )
	{
		$this->JCAT_UICtrlHtmlMBox($sName, $sUIName) ;
		
		$this->sMainUITemplate = dirname(__FILE__).'/../../Skin/UITemplate/template.Ext_JCSystem_ExtensionSelect.html' ;
		$this->SetMultiItemDataDelimiter(JCAT_UICtrlHtmlMultiItem::ARRAY_DELIMITER) ;
	}
	
   	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	int
	 */
	public function LoadExtensions( W3B_DependenceTree $aExtDependTree ) 
	{
		$aIter = $aExtDependTree->CreateDependItemIter() ;
		
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aItem = $aIter->Current() ;
			$this->AddExtension($aItem) ;
		}
		
		$this->aExtDependTree = $aExtDependTree ;
	}
	
	/**
	 * Description
	 *
	 * @access	private
	 * @return	void
	 */
	private function AddExtension(W3B_DependenceItem $aItem)
	{
		if($aItem->GetItemName()==='Platform')
		{
			return ;
		}
		
		$aExtInfo = $aItem->GetAttachment() ;
		JCAT_ASSERT::ASSERT_INSTANCE($aExtInfo,'W3B_IExtensionInfo');
		$sExtName = $aExtInfo->GetName() ;
		$sExtTitle = $aExtInfo->GetTitle() ;
		
		$nItemIdx = $this->AddItem("{$sExtTitle}({$sExtName})",$sExtName) ;	
		$aCheckbox = $this->GetItem($nItemIdx) ;
		$aCheckbox->SetAttribute('title',$aExtInfo->GetDescription()) ;
		$aCheckbox->SetAttribute('onclick',"OnClickExtension(this,'{$sExtName}')") ;
		$aCheckbox->SetAttribute('bAbstract',$aExtInfo->IsAbstract()?'1':'0') ;
		$aCheckbox->SetHtmlId('chkbox'.$sExtName) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sExtensionName
	 * @return	void
	 */
	public function SetSelectedExtension($sExtensionName)
	{
		$arrSelectedValues = array($sExtensionName) ; 
		
		$aIterator = $this->CreateDependenceIter($sExtensionName) ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aDepend = $aIterator->Current() ;
			$arrSelectedValues[] = $aDepend->GetItemName() ;
		}
		
		$this->SetItemActiveByValue($arrSelectedValues,true,false) ;	
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$Parameter
	 * @return	void
	 */
	public function SetLockedExtension($sExtensionName)
	{
		$arrDisableValues = array($sExtensionName) ; 
		
		$aIterator = $this->CreateDependenceIter($sExtensionName) ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aDepend = $aIterator->Current() ;
			$arrDisableValues[] = $aDepend->GetItemName() ;
		}
		
		$this->SetItemActiveByValue($arrDisableValues,true,false) ;
		$this->SetItemDisableByValue($arrDisableValues,true,false) ;	
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return			JCAT_IIterator
	 */
	public function CreateDependenceIter($sExtName,$bReverse=false)
	{
		JCAT_ASSERT::ASSERT_INSTANCE($this->aExtDependTree,''
					, JCAT_Language::SentenceEx('尚未调用方法：Ext_JCSystem_ExtensionSelect::LoadExtensions()','JCAT',null)) ;
		
		if($this->aExtDependTree)
		{
			$aExtItem = $this->aExtDependTree->GetDependenceItem($sExtName) ;
			if($aExtItem)
			{
				return new W3B_DependenceAdvIterator($aExtItem,$bReverse,0) ;
			}
		}
		
		return new JCAT_NullIterator() ;
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		W3B_DependenceTree
	 */
	private $aExtDependTree ;
}

?>