<?php
/**
 * 扩展：Ext_JCSystem
 * 
 * @access	public
 */
class Ext_JCSystem extends W3B_Extension
{	
	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		// 注册菜单配置函数
		$theEventDispatcher->RegisterHandle(
				Ext_JCHtmlFrame::EVENT_REG_ADMIN_MENU
				, array(__CLASS__,'SetupAdminFrameMenu') , array()
				, Ext_JCHtmlFrame::EVENT_NAMESPACE) ;
	}
	
	
	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		// 调用父类方法，完成初始化工作
		parent::Load($aService) ;
		
		W3B_Platform::RegisterHTTPPublicController('Ext_JCSystem_CreateNewService') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCSystem_AdminServiceList') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCSystem_BuildPatch') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCSystem_ApplyPatch') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCSystem_BuildInstalledExtensionDB') ;
	}
	

	/**
	 * 配置 管理框架 菜单
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function SetupAdminFrameMenu(JCAT_UICtrlHtmlMenu $theFrameMenu,W3B_Service $aService)
	{
		// 平台管理员
		$aAuthenticator = self::CreateAuthenticator() ;
		if( $aAuthenticator->Authorize($aService->GetIdManager()) )
		{
			$sMenuXML = '<Menu>
	<MenuItem text="系统" package="Ext_JCSystem" link="?controller=Ext_JCSystem_AdminServiceList">
		<MenuItem text="平台" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_ApplyPatch">
			<MenuItem text="创建补丁" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_BuildPatch" />
			<MenuItem text="应用补丁" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_ApplyPatch" />
			<MenuItem text="设置SMTP" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_SMTPSetting" />
		</MenuItem>
		<MenuItem text="服务" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_AdminServiceList">
			<MenuItem text="创建新服务" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_CreateNewService" />
			<MenuItem text="服务管理" package="Ext_JCSystem" link="/?controller=Ext_JCSystem_AdminServiceList" />
		</MenuItem>
		<MenuItem text="扩展" package="Ext_JCExtensionManager_InstalledList" link="/?controller=Ext_JCSystem_PlatformExtensions">
			<MenuItem text="全平台扩展管理" package="Ext_JCExtensionManager_InstalledList" link="/?controller=Ext_JCSystem_PlatformExtensions" />
			<MenuItem text="本服务扩展管理" package="Ext_JCExtensionManager_InstalledList" link="/?controller=Ext_JCSystem_PlatformExtensions" />
			<MenuItemHide text="扩展交易中心" package="Ext_JCExtensionManager_InstalledList" link="/?controller=Ext_JCSystem_PlatformExtensions" />
		</MenuItem>
		
	</MenuItem>
</Menu>' ;
	
			$theFrameMenu->BuildMenuFromXML($sMenuXML,false) ;
		}
	}
	

	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IAuthorizable
	 */
	static public function CreateAuthenticator($nServiceId=0)
	{
		$aAuthenticator = new Ext_JCUser_Authenticator() ;
		$aAuthenticator->AddAllowIdentity(Ext_JCUser_Identity::ID_CLASS);
		$aAuthenticator->AddPurview(
				Ext_JCUser::PLATFORM_ADMIN
				, Ext_JCUser::PLATFORM_ADMIN_DOMAIN
				, $nServiceId ) ;
		
		return $aAuthenticator ;
	}
}

?>