<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 Ext_JCUser_Document 
 *
 * @access public
 */
class Ext_JCUser_Document 
	extends JCAT_DBDocument
{
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCUser_Document(JCAT_DB $aDB=null)
	{
		// 调用父类构造函数 
		$this->JCAT_DBDocument(__CLASS__,'Ext_JCUser','nUserId'
				, array(
				
					'Ext_JCUser.nUserId',
					'Ext_JCUser.sUserName',
					'Ext_JCUser.sPassword',
					'Ext_JCUser.sEmail',
					'Ext_JCUser.nCreateTime',
					'Ext_JCUser.nLastLoginTime',
					'Ext_JCUser.nActiveTime',
					'Ext_JCUser.sLastLoginIP',
					
					// 联系方式
					'Ext_JCUser.sQQ',
					'Ext_JCUser.sMSN',
					'Ext_JCUser.sHome',
					'Ext_JCUser.sTel',
					'Ext_JCUser.sFax',
					'Ext_JCUser.sMobile',
					'Ext_JCUser.sEmail',
				
					// 个人信息
					'Ext_JCUser.nBirthday',
					'Ext_JCUser.nSex',
					'Ext_JCUser.sFace',
					
				), $aDB ) ;

		$this->Initialize() ;	
	}

	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function __sleep()
	{
		$arrSavePropertys = parent::__sleep() ;
		$arrSavePropertys[] = JCAT_Package::MakePrivatePropertyNameForSerialize('arrPurviews',__CLASS__) ;
		
		return $arrSavePropertys ;
	}
	
	/**
	 * 初始化 视图 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{
		$this->aUserPurviewLinkAggDoc = new Ext_JCUser_UserPurviewLinkAggDoc() ;
	}

	/**
	 * 检查用户名是否存在
	 *
	 * @access	public
	 * @param	$sUserName		string
	 * @return	bool
	 */
	static public function IsUserExists($sUserName)
	{
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		return ($aDB->SelectOneRow('Ext_JCUser',"sUserName='{$sUserName}'")!==null) ;	
	}
	
	/**
	 * 检查用户名是否存在
	 *
	 * @access	public
	 * @param	$sEmail		string
	 * @return	bool
	 */
	static public function IsEmailExists($sEmail)
	{
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		return ($aDB->SelectOneRow('Ext_JCUser',"sEmail ='{$sEmail}'")!==null) ;	
	}

	/**
	 * What's this Method ?
	 * 
	 * @access	public
	 * @return	bool
	 */
	public function Load(W3B_Service $aService)
	{
		if( !parent::Load() )
		{
			return false ;
		}
		
		$this->LoadPurviewLink() ;
		return true ;
	}
	
	/**
	 * 载入权限连接
	 *
	 * @access	private
	 * @return	void
	 */
	private function LoadPurviewLink()
	{
		// 载入权限
		$this->arrPurviews = array() ;
		$aUserPurviewLinkAggDoc = new Ext_JCUser_UserPurviewLinkAggDoc() ;
		$aUserPurviewLinkAggDoc->SetUserId($this->GetPrimaryKeyValue()) ;
		$aUserPurviewLinkAggDoc->Load() ;
		
		$aIterator = $aUserPurviewLinkAggDoc->CreateDocumentIterator() ;
		$aIterator->First() ;
		while( !$aIterator->IsDone() )
		{
			$aLink = $aIterator->Current() ;
			
			$sPurviewDomain = $aLink->Get('Ext_JCUser_Purview.sPurviewDomain') ;
			$this->arrPurviews[$sPurviewDomain][] = $aLink ;
			
			$aIterator->Next() ;
		}	
	}
	
	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$sPurviewDomain=null		string		指定权限名称
	 * @return	array
	 */
	public function GetPurviews($sPurviewDomain=null)
	{
		if( $sPurviewDomain===null )
		{
			return $this->arrPurviews ;
		}
		
		else 
		{
			return isset($this->arrPurviews[$sPurviewDomain])? $this->arrPurviews[$sPurviewDomain]: null ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_DB
	 */
	public function GetDB()
	{
		$aExtension = W3B_Extension::GetExtensionInstance('Ext_JCUser') ;
		return ($aDB=parent::GetDB())? $aDB: $aExtension->GetPrimaryDB() ;
	}


	/**
	 * 添加一项权限
	 * 
	 * @access	public
	 * @param	$nPurviewId			int			权限ID
	 * @param	$nSince=0			int			
	 * @param	$nExpir=0			int			
	 * @return	bool
	 */
	public function AddPurview( $nPurviewId, $nSince=0, $nExpir=0 )
	{
		$nUserId = $this->GetPrimaryKeyValue() ;
		JCAT_ASSERT::ASSERT_($nUserId,JCAT_Language::SentenceEx('用户对象尚未载入。','Ext_JCUser',null))  ;
		
		$aLinkDocument = new Ext_JCUser_UserPurviewLinkDoc() ;
		$aLinkDocument->Set('nPurviewId',$nPurviewId) ;
		$aLinkDocument->Set('nUserId',$nUserId) ;
		$aLinkDocument->Set('nSince',$nSince) ;
		$aLinkDocument->Set('nExpir',$nExpir) ;
		
		// 创建连接
		if( $aLinkDocument->Create() )
		{
			// 重新载入 权限连接
			$this->LoadPurviewLink() ;
			return true ;
		}
		else 
		{
			return false ;
		}
	}
	
	/**
	 * 移除一项权限
	 * 
	 * @access	public
	 * @param	$nPurviewId			int			权限 ID
	 * @return	bool
	 */
	public function RemovePurview( $nPurviewId )
	{
		$nUserId = $this->GetPrimaryKeyValue() ;
		JCAT_ASSERT::ASSERT_($nUserId,JCAT_Language::SentenceEx('用户对象尚未载入。','Ext_JCUser',null))  ;
		
		$aDB = $this->GetDB() ;
		if( $aDB->Delete('Ext_JCUser_PurviewLink',"`nPurviewId`={$nPurviewId} and `nUserId`={$nUserId}") )
		{
			// 重新载入 权限连接
			$this->LoadPurviewLink() ;
			return true ;
		}
		else 
		{
			return false ;
		}
	}
	
	
	// 属性 //////////////////////////////////////////////////////////////
	
	private $arrPurviews = array() ;
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		Ext_JCUser_UserPurviewLinkAggDoc
	 */
	private $aUserPurviewLinkAggDoc ;
}

?>