<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 Ext_JCUser_UserPurviewLinkDoc 
 *
 * @access public
 */
class Ext_JCUser_UserPurviewLinkDoc 
	extends JCAT_DBDocument
{
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCUser_UserPurviewLinkDoc(JCAT_DB $aDB=null)
	{
		// 调用父类构造函数 
		//<<[UnmodifiableBlock.Start]::Call Parent Construct::>>//
		$this->JCAT_DBDocument(__CLASS__,'Ext_JCUser_PurviewLink','nPurviewLinkId'
				, array(
					'Ext_JCUser_Purview.nPurviewId',
					'Ext_JCUser_Purview.nServiceId',
					'Ext_JCUser_Purview.sPurviewName',
					'Ext_JCUser_Purview.nPurview',
					'Ext_JCUser_Purview.sPurviewDomain',
					'Ext_JCUser_Purview.sComment',
					'Ext_JCUser_PurviewLink.nPurviewLinkId',
					'Ext_JCUser_PurviewLink.nPurviewId',
					'Ext_JCUser_PurviewLink.nUserId',
					'Ext_JCUser_PurviewLink.nGroupId',
					'Ext_JCUser_PurviewLink.nSince',
					'Ext_JCUser_PurviewLink.nExpir',
				), $aDB ) ;
		//<<[UnmodifiableBlock.End]::Call Parent Construct::>>// 

		$this->Initialize() ;	
	}
	
	/**
	 * 初始化 视图 
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function Initialize()
	{		
		//<<[UnmodifiableBlock.Start]::DB Table Link::>>//
		// 数据表连接设置
		$aTableJoin = $this->GetTableJoin() ;
		$aSQLFactory = $aTableJoin->GetFactory() ; 
		$sTableJoinOn = $aTableJoin->GetSubSQLOn() ; 

		// 连接数据表 Ext_JCUser_PurviewLink 和 Ext_JCUser_Purview ::::::::::
		$aTableJoin->AddTable('Ext_JCUser_PurviewLink') ; 
		$aTableJoin->AddTable('Ext_JCUser_Purview',false) ; 
		// 条件组
		$aConditionGroup0 = $aSQLFactory->CreateSubSQLConditionGroup(true,$sTableJoinOn) ; 
		$aCondition = $aSQLFactory->CreateSubSQLCondition($aConditionGroup0,$aSQLFactory->CreateColumn("Ext_JCUser_Purview.nPurviewId"),$aSQLFactory->CreateColumn("Ext_JCUser_PurviewLink.nPurviewId"),'=',null) ; 
		$aConditionGroup0->AddCondition($aCondition) ;
		$sTableJoinOn->AddCondition( $aConditionGroup0 ) ;
		//<<[UnmodifiableBlock.End]::DB Table Link::>>// 
		
		//<<[UnmodifiableBlock.Start]::Query Condition::>>//
		// 查询条件设置
		$aSubSQLWhere = $this->GetSubSQLWhere() ; 
		$sSQLFactory = $aTableJoin->GetFactory() ; 

		//<<[UnmodifiableBlock.End]::Query Condition::>>// 

		//<<[UnmodifiableBlock.Start]::Document Children::>>//

		//<<[UnmodifiableBlock.End]::Document Children::>>// 
		
		
		// 在此加入其它初始化代码 
	 	// TODO ... ...

	}

	
	/**
	 * 返回这项权限是否有效
	 *
	 * @access	public
	 * @param	$nPurviewBit				int			权限位
	 * @param	$sPurviewDomain=null		string		指定权限名称
	 * @param	$nServiceId=null				int			指定服务
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewDomain=null,$nServiceId,$nTime=null)
	{
		if($nServiceId===null)
		{
			$nServiceId = W3B_Service::GetCurrentServiceId() ;
		}
		JCAT_ASSERT::ASSERT_INT($nServiceId) ;
		
		// 检查 是否指定服务
		$nPurviewServiceId = $this->Get('Ext_JCUser_Purview.nServiceId') ;
		if( $nPurviewServiceId>0 and $nPurviewServiceId!=$nServiceId )
		{
			return false ;
		}
		
		// 检查权限内容
		if( $this->Get('Ext_JCUser_Purview.sPurviewDomain')!==$sPurviewDomain )
		{
			return false ;
		}
		if( !($this->Get('Ext_JCUser_Purview.nPurview')&$nPurviewBit) )
		{
			return false ;
		}
		
		// 检查期限
		$nSince = $this->Get('Ext_JCUser_PurviewLink.nSince') ;
		$nExpir = $this->Get('Ext_JCUser_PurviewLink.nExpir') ;
		if($nTime===null)
		{
			$nTime = time() ;
		}
		else
		{
			JCAT_ASSERT::ASSERT_INT($nTime) ;
		}
		
		if( $nSince!=0 and $nSince>$nTime )
		{
			return false ;
		}
	
		if( $nExpir!=0 and $nExpir<$nTime )
		{
			return false ;
		}
		
		// 通过
		return true ;
	}
}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:DBDocumentDoc}}>>
eCVEQSVBNVUlQ0RuJURBJTQwJTEwJUJFVyVFQSUzQiUxMCUzRiUwMCVDNiVEOCU4NGQlRjMlMjMlMDUlMDMlMTUuNjglQzYlOEVyJThBJTFDJUIzLSU4RSUxNyUxQiVEOSVBNiVGQyUwOSVBOSU4NyVCNiVBNyVBQVIlQUYlOTV6JUU4S1QlOTUlMTIlRjVpJUQyJUJGUyU1RSVBMSVCM2slMDg0JTgxOCVBMkJrZiUzRDMl
REYlN0MlQkIlRkIlRUQlRDhGeTQlODklOTAlODQlQjglQjIlMUQlREIlREMlOUUlOEQlOEF0JUJFJThCOCVENXYlRkQlOTYlN0ROMCVCNyUxNyVBMSU3QyUxRXElOTVhJTdDJUE2JUM4ZiU4NCVDMyVCM2YlM0YlN0MlRTUlRTJBJUREJUY1JTNEJUVBLSUyNiVEMSVDRiVGMSU4OCVDRSUwNCUwMCVGMyU5NyUyMmptJUY2
NiU4NzglQzglOTUlMDMlRDIlRUYlRkElMTEtJTI0JTg4aCVFMiVBMiUxQ1glOEMlQzIlMEUlRTIlOUMlOEVLJURBJTIxJUY2JUE5NyU4NyUyNlMlRUElODUlREElQkIlQUJqZyVFNyUyNSUyOCUzQ0QlMEElMUIlRTMlMTglMTglMEMlMDclQ0ZwJUYyJUE5OCVBMiVCMCUxMiUyNyU5QSUxOSU5QSVERCVDNSUwQ0lMZ1Ql
N0NwZSUwQ0VKJUU3JTIzJTNFJUM4JUE3JTFDdCVFMWwlMThWYVNGJTkxJTFDdCVCQiVEOCU4RiUxOSVDQXYlM0ElQTMlRTIlM0ElQjVkJUVGJTBBJTAzMiU4QSUxQiVBRSVGMCUxRiVCQyUxOSVENk4lM0FWbiUzRCUxNiU3RDMlMDMlREElRERQJTA2JTA5JUQwJUIzMCVFOCVGNyVFNiVDMiVEQ1QlRTElMDklOTQlRTEl
RkFOJUEyJTI3QSVGOCUyRiVBMCVDQSVCMCVFNyU4NiUwOVAlQkElQzZhJTkzK3QlQ0ElMUElMDFrJTAyJUM5VSU4N0slM0IlQkYlQjMlQzUlMTUlRjklOUIlM0IlMTclOTUlQjclMEIlMjklQjclM0RzJTkweSU4NCUxNmhDJTgwJUE2JTgzOCU5MSVEQSVGOSVDNyVCNSUxMXpnWSVEMiUwMSVCNSVBNSVDNyUyQiU4RiU1
RSVBRCVEQk0lNUIlRTglRUMlRTclRTclMkYlRDclOTdfJTdGJTVEJUJFJUI5JUI5eiUwRiVDRiUxRiVFRiVERSVGRXklN0QlRjklRkIlRkIlQzclOUIlQUJPJUQ3JURGJTNFJTJDJTkxJUNDJUNGSTIlODglODQlQzYlQ0MlOTQlMTYlRTYlQkQlMUElRDIlRjYlM0F2JTE5JUE1USVEM1YlRUMlRDNSTSVFMXZjJTFFJUU4
JUVEJTA5JTE1aCVFOCUxNG9ORyVEOFklOTVwJTg3YSVGMiUxRCVEMCVGQjglMUMlQzklODElREZ2YzclQjglM0RpJUYwQSVDRHIlRTAlRjRpU2klREFxJTg3JTdEJTIxJTA0OCUyMSVCRSUxM3QxbyUxMyU4QyVGOWYlMTglNUMlNjAlMjclRTYlMTUlMkMlREIxJTdGJTIyJTk2JTlBJUM0JThFXyUwNGElOTclODclRTIl
RDglOEYlMDAlOTBfJUQwJUUwJTg1bCU4RSVGRTI2JUU5dWwlNUUlMjZ2JTE0JUUxJTg4dyVFOCU3RnYlODktJTdEJTJDLSUxMUhkJTdCJTlEJTFFJUFCJUJGJUM0JTI5aSVFMiVGN0RzJTNGJTE5JTk2JUNBJUM0JTJDJUFGUiVCQUglOTUlMEV6ZiUyNCUxOCUxQ0wlMTQlRjklQTglQTVaciVFMyU5Qy4lMEUlQjYlMjYl
ODYlRUUlOENDJTA2JUM1diVEQSU5RiU5NSUxNiVFMCU4QytuJTAxJUNDJUJDbSVGNiU5NSUwNiUyNCUwOSVEQyVGQiVGQiU5MyVDOSU5QzElNUIwWiUwQiUzRSU5RCUxRSUxRSUzRSU3RCU4MmUlQUIlQTIlOUIlMTElRDElMkYlRjQlOTFiJUQ2ciU4QVktJUQ1JTVESyVENi5qJUYwJUFFajglOUVHVE9TJTJDJUQ5JTky
VU9KJUUyWkclMTAlN0IlM0ElQUMlMUJWSSUxRiU5OSUwNU02JTBCJUZBWCUxRDlCJThENCUyQVUlMDMlN0NjJUE1JUE1JTBGTiU1RHMlQTAlOTFTciU1QzYlMjElMEYlQzYlRDglM0FRWiUyRiVGM3RYJTVFJTQwJThFTSVCMyUwMCVCMSUwNSVDMzAlQTVGJUNCJTIzWiVDRSUyNCU4RCVCMiUwNyVCMTAlNjAlQUUlOEYl
Q0QlMDElQzRCJUNDcSVFOSUwNCVCMFQlQ0F1ZFVUJUMzJTFDaiU4NlVVJThGJUI2JUI2JUE4JUIwJUE2JTdGJTAxJUZEJTIxJUU3JTk3
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>