<?php


class Ext_JCUser extends W3B_Extension
{
	const PLATFORM_ADMIN_DOMAIN = 'W3B_Platform' ;
	const PLATFORM_ADMIN = 1;
	
	const SERVICE_ADMIN_DOMAIN = 'Ext_JCHtmlFrame:Admin' ;
	const SERVICE_ADMIN = 1 ;

	/**
	 * 取得扩展名称
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionName()
	{
		return 'Ext_JCUser' ;
	}

	/**
	 * 取得扩展的标题名称
	 * 
	 * @access	public
	 * @param 	$sLanguage=JCAT_Language::CURRENT_LANGUAGE		string	指定语言，null表示当前语言
	 * @static
	 * @return	string
	 */
	static public function GetExtensionTitle($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('JeCat 基本用户功能扩展','Ext_JCUser',$sLanguage) ;
	}
	
	/**
	 * 取得扩展的描述
	 * 
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetExtensionDescription($sLanguage=JCAT_Language::CURRENT_LANGUAGE)
	{
		return JCAT_Language::SentenceEx('提供基础的用户注册、登录功能。可以对此扩展进行扩展，以实现更具体的用户类型。','Ext_JCUser',$sLanguage) ;		
	}
	
	
	/**
	 * 取得扩展的当前版本号
	 *
	 * @access	public
	 * @return	JCAT_Version
	 */
	static public function GetVersion()
	{
		return new JCAT_Version(1,0,0,0,'alpha') ;
	}

	/**
	 * 取得扩展的兼容版本号
	 * 扩展自此版本以来，接口未发生任何变化，依赖此版本的其它扩展，可在当前版本上正常工作。
	 *
	 * @access	public
	 * @static 
	 * @return	void
	 */
	static public function GetCompatibleVersion()
	{
		return self::GetVersion() ;
	}

	/**
	 * 注册可托管类
	 * 
	 * @access	public
	 * @param 	$theClassTrustee	W3B_ClassTrustee	托管器
	 * @return	void
	 */
	public function RegisterInTrustClass(W3B_ClassTrustee $theClassTrustee)
	{
		$theClassTrustee->DeclareClass('Ext_JCUser_Identity',array('JCAT_IIdentity')) ;
	}
	
	
	/**
	 * 注册事件
	 * 
	 * @access	public
	 * @param 	$theEventDispatcher		JCAT_EventManager	事件调度器
	 * @return	void
	 */
	public function RegisterEvent(JCAT_EventManager $theEventDispatcher)
	{
		//$theEventDispatcher->DefineEvent(self::EVENT_BeforeLogin,array(),JCAT_Language::SentenceEx('登录前','Ext_JCUser',null)) ;
		$theEventDispatcher->DefineEvent(self::EVENT_LoginSuccess,self::EVENT_NAMESPACE
				, JCAT_Language::SentenceEx('登录成功','Ext_JCUser',null)
				, array('Ext_JCUser_Identity','W3B_IController') );
		//$theEventDispatcher->DefineEvent(self::EVENT_LoginFail,array(),JCAT_Language::SentenceEx('登录失败','Ext_JCUser',null)) ;
	}
	
	// 事件名称常量
	const EVENT_NAMESPACE = "\\Ext\\JCUser" ;
	const EVENT_BeforeLogin = 'BeforeLogin' ;
	const EVENT_LoginSuccess = 'LoginSuccess' ;
	const EVENT_LoginFail = 'LoginFail' ;
	const EVENT_BeforeLogout = 'BeforeLogout' ;
	const EVENT_AfterLogout = 'AfterLogout' ;

	/**
	 * 加载扩展
	 *
	 * @access	public
	 * @return	void
	 */
	public function Load(W3B_Service $aService)
	{
		parent::Load($aService) ;
		
		W3B_Platform::RegisterHTTPPublicController('Ext_JCUser_Login') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCUser_Logout') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCUser_Register') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCUser_Modify') ;
		W3B_Platform::RegisterHTTPPublicController('Ext_JCUser_ModifyAccount') ;
		
		// 设置访问路由
		$aRequestDispatcher = $aService->GetRequestDispatcher() ;
		$aRequestDispatcher->RegisterControllerAlias('Login','Ext_JCUser_Login') ;
		$aRequestDispatcher->RegisterControllerAlias('Logout','Ext_JCUser_Logout') ;
		
		// 设置权限
		$this->RegisterPurview("系统","平台管理员"
				, Ext_JCUser::PLATFORM_ADMIN_DOMAIN, Ext_JCUser::PLATFORM_ADMIN ) ;
		$this->RegisterPurview("系统","服务管理员"
				, Ext_JCUser::SERVICE_ADMIN_DOMAIN, Ext_JCUser::SERVICE_ADMIN ) ;
	}

	/**
	 * 注册一个回调函数，当 登录成功 通过调用这个函数 返回前往地址
	 *
	 * @access	public
	 * @param	$Callback
	 * @static
	 * @return	string
	 */
	static public function RegistorGetAboardUrlHandle($Callback)
	{
		JCAT_ASSERT::ASSERT_ISTHESE($Callback,array('callback','null')) ;
		self::$GetAboardUrlHandle = $Callback ;
	}
	
	/**
	 * 取得 登录成功 跳转地址
	 *
	 * @access	public
	 * @static
	 * @return	string
	 */
	static public function GetAboardUrl()
	{
		if( self::$GetAboardUrlHandle )
		{
			return call_user_func(self::$GetAboardUrlHandle) ;
		}
		
		else 
		{
			return null ;
		}
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	JCAT_IAuthorizable
	 */
	static public function CreateAuthenticator()
	{
		$aAuthenticator = new JCAT_CommonAuthenticator() ;
		$aAuthenticator->AddAllowIdentity(Ext_JCUser_Identity::ID_CLASS);		
		return $aAuthenticator ;
	}
	

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$s
	 * @return	void
	 */
	public function RegisterPurview($sGrp,$sName,$sPurviewDomain,$nPurviewBit)
	{
		$this->arrPurviews[$sGrp][$sName] = array(
			$sPurviewDomain, $nPurviewBit
		) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	JCAT_IIterator
	 */
	public function CreatePurviewGroupNameIter()
	{
		return new JCAT_ArrayIterator(array_keys($this->arrPurviews)) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sGrpName
	 * @return	JCAT_IIterator
	 */
	public function CreatePurviewNameIter($sGrpName)
	{
		if( isset($this->arrPurviews[$sGrpName]) )
		{
			return new JCAT_ArrayIterator(array_keys($this->arrPurviews[$sGrpName])) ;
		}
		
		else
		{
			return new JCAT_NullIterator() ;
		}
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sGrpName
	 * @param	$sPurviewName
	 * @return	JCAT_IIterator
	 */
	public function GetPurviewBit($sGrpName,$sPurviewName)
	{
		return isset($this->arrPurviews[$sGrpName][$sPurviewName])?
					$this->arrPurviews[$sGrpName][$sPurviewName][1]: null ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sGrpName
	 * @param	$sPurviewName
	 * @return	JCAT_IIterator
	 */
	public function GetPurviewDomain($sGrpName,$sPurviewName)
	{
		return isset($this->arrPurviews[$sGrpName][$sPurviewName])?
					$this->arrPurviews[$sGrpName][$sPurviewName][0]: null ;
	}
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrPurviews = array() ;
	
	/**
	 * 
	 * 
	 * @access	private
	 * @static
	 * @var		string
	 */
	static private $GetAboardUrlHandle = null ;
}




?>