<?php 
/**
 * ... ...
 * ... ...
 *
 */ 



/**
 * 控制器类 Ext_JCUser_List 
 *
 * @access public
 */
class Ext_JCUser_AdminList 
	extends W3B_Controller 
{
	const MODEL_LIST = 'MODEL_LIST' ;
	const VIEW_LIST = 'VIEW_LIST' ;
	
	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_AdminList(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		//<<[UnmodifiableBlock.Start]::Message Queue::>>//
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_OK) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_BAD) ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,MSGMVC_DEBUG) ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter($aMessageQueue)) ;

		$this->SetMessageQueue($aMessageQueue) ;
		//<<[UnmodifiableBlock.End]::Message Queue::>>// 

		$aModel = new Ext_JCUser_AggModel() ;
		$this->AddModel($aModel,self::MODEL_LIST) ;

		// 创建并加载视图
		$aView = new Ext_JCUser_ViewAdminList($this) ;
		$aView->SetModel($aModel) ;
		$this->AddView($aView,self::VIEW_LIST) ;
		
		$this->InitializeFrameMenuPath() ;
	}

	/**
	 * Description
	 *
	 * @access	protected
	 * @return	void
	 */
	protected function InitializeFrameMenuPath()
	{
		$aRequest = $this->GetRequest() ;
		$aRequest->SetParam(Ext_JCHtmlFrameAdmin_Controller::PARAM_MENU
			, JCAT_Language::SentenceEx('用户管理','Ext_JCUser',null)
		) ;
	}
	
	/**
	 * 执行入口函数 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function MainRun()
	{
		$aService = $this->GetService() ;
		$aIdMgr = $aService->GetIdManager() ;

		// 认证
		$aFrame = new Ext_JCHtmlFrameAdmin_Controller($aService,$this->GetAuthenticator()) ;
		$aFrame->SetRequest($this->GetRequest());
		if( !$aFrame->Authorize($aIdMgr) )
		{
		    $aFrame->DenyAccess() ;
		    return ;
		}
		
		
		$aView = $this->GetView(self::VIEW_LIST) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aView,'JCAT_IViewHtml');
		
		$aModel = $aView->GetModel() ;
		
		// 搜索
		$aRequest = $this->GetRequest() ;
		if( $sUsername=$aRequest->GetParam('sUsername') )
		{
			$aModel->FindBy('sUserName',"%{$sUsername}%",'LIKE') ;
		}
		
		$aModel->Load() ;
		
		
		$aFrame->RenderFrame($aView) ;
		// $aView->ShowView() ;
	}

}

?><?
/**
 * [注意!!]
 *	以下内容由 JCAT PHP Toolbox 自动维护，手动更改的内容会被 JCAT PHP Toolbox 抹除，
 *	同时还可能破坏格式，导致 JCAT PHP Toolbox 无法正常读取。
 */
/*<<[UnmodifiableBlock.Start]::Coder Dialog Data::>>&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&//
<<{{DocumentClass:ControllerDoc}}>>
eCVEQSU4RFMlQzFuJURCRiUxNCVCQyUxNyVFOCUzRjglRkMlMDAlOEIlMTQlQTUlRDQlQTUlODMlMDAlMTJJJTI5JURBZCUyOSUyRiVDOSVBNSUyMyU1RCUwQ1olREFIJTE0VyVBMislRDIlOTUlMjhDJUQ3JTlDeiVFOTklRTglMjElNDAlODElMUVzLiU4MiVFNGslRTIlQzIlOUYlRDFZJTJBJUIyJUUzJTAyJThEJTBC
YkFyJUY3JUJEJTk5eSVGMyVERSVDNlYlREQlQkElQ0UlQUQlODYlQTU5cSUxMWslQTclQjElRDVUJUZGJTA2NiVFQ2xRJUFDMiUyOSVDNSVFQSUyQy4lQTYlREElMjl2JUY1JUE2JUE1JUQ1JUE2JUQ5JTVDJUQ0YiUyOUQlRURsJTk1JUNEJUM0JUE4JUE4JTExYSVDN0UlRUQlRENsJTlGJUM5JUI4eCU5MyVBRCVFNjV3
UyU4OEUlOUVkJTBCJUY1dUFsJTlFJThCVSVDRDglRDYlRDVzJTE0JUNCJUU1NCVBRSVEOTIlQ0VzJTkxJUQ3RiVFQSU3RCU3QyUxRnYlRjElMkElQzklOEIlRTMlRTV0WTElM0UlRDAlRTElQzVzUSVFREIlQzYlQkYlMTIlRDQlRjZPJTk2RiVGM0lYLiVDNSVENyUzQSUxMkslQzdHVSVFMCU4OSVBNSU4RCVBNiU4OSUx
QyVBRiVDNEIlMUQlRUElRDYlRjVOJTlEJUU2JUQ2UyUyNCUwNSU1RCUxQSVEOSVEQSUyOXYlOENHJUUzJTdGJTNFJUM0XyVGNF9WJTI5JUY1R1MlMEMlRkQuJUE3JUREciVBQSUyNCVGMyVGMSVBNCVGQSU1RCU5MiVFMyVCNnklQjdKayUzQyU5QSUwNiUyQUQlRUUlRjYlM0ElRjMlQzklRDklMkElMjklQzRKJTg1JTk4
JTA3JTNCJTFBJURGJUM5JUJGJTg0JTAxJUNBJTA0JUQwJTFCJTk2JUY2JTIyJUE0JUFGJThFbiVGRiU3QyU3QiVGMyVFRSVCM3YlQUElMEElQ0QlQUQlQkFpaSVDNG4lODUlMTdUJUU0eSUzQyUxMSUyQSUwNCUxQyU4QiU4QSVFNCVBQiU3RiVERiUyNyVEMCUwRiUwNCU0MCVFQSUxNiVFOSVEMSVDRCU4NyVCRm4lM0Yl
RkMlRkUlRjclRkIlQjd3JTE0JTI3JTBGJTI5JTEwJUU0JTI0JUIxJUNDJTI2JURGJUYyJUQ0JUZGNyUwRiU3QyVCOCVGOSVFRCVEMyU5NyU4RiU3RiVEQyVCRSVGRiVGNSU0MGElRUElMEYlMjklRUNsJTNFJThGJTE3YyU5OSUyQyVDNCUzRCVDOW5vJTAyJTI2JTBDJTNFJUIyJTJCcSVCNSUxRiUzREszcFglMTElREIl
REYlMTAlMUIlMDclN0JNJUE1JTBBJUYzWSU4RCVCNSVDQSVBODclRjdkJUU4ZCVGRlIlNUQlMTc1JUNGMSVBOFZONlIlMDElMTglRjElQzVhJUIwJTAxJThGJUI4JTdCJUUwJUVBdCU1QyVEREwlQ0MlRjdTJTE0JUYzJUVDJUQ5JUY1NSUxMiVBRiVFNmJRVFclQzglRkFPJUYwJUREJUVFJUY5JUYzJTFGJTdGJTEwdiVF
NCVCMiU4MCU5QiVCRSVDRCUxQiU3RSUxMjklRjQlM0MlOTNsSyVENyUyNHQlRDclQkUlMUR1JUZEJTk0SyVDQSUwNyVEMiU5QiVCNSVBNCVFRiVBNCVCMiVFRiVCQSVCMiUxRlIlMkMlMjYlRkQlMTklOTclMkNMJTFCJTI0JUVDJTE5JTI0JTlDNEklRDhqJTEyTjclMjRMdSVDMiU3QnpURjY1JTA3JTg4JTFEJTBGWCUx
MCVEOSU1RSVDMiUxQiVBQyU4QyVEQSU1RSVDMDclRDQlQTUlQzBrSSU5NiUwRU0lM0YlRTBlJTFGJUU3JThBJUNGJTBCJTA3JTkyJUVBJTNESSU1RCVFRiU5N2ElODk4JTg3JTAwJURGayUwMyVCNyUwMSU4QyUwRSVGMiU1RGpHbVolMjIlQzclQzZ5JTg3JTAxJUMzJTdCQ0IlQjYlREUlRjMlMTIlRDclOTMlMjclNUIl
MTJOJTVEJUMyJUQ5JTg2cCVBRSVCRSUxRCVFOCVBQiVFRiVDRiVBOUElRjglQTAlRUVvJTI3JUE4cyUxQSVBOCUzQSVBMyslRUElRjZfJTJGJTk3JTg4JUVCJTkwUHYlQjElREElMjQlRUN0JTA4d0slNjAlMjglREM1JUVBJTAxJTE2JUIxJUNGJTAzJURFJTAwdyUxMyUxQSVBMCU5N28lN0MlMTc4JTIxJUY0JUNFJTk0
JTJGJTNEeCUxMiVFNSU5NyVEMCVFOCVCRCU5MEMlOEUlRDglN0UlQzAlMEQlM0YlQzAlM0ZqJUY3JUNBJUE4JUNCJUNFJTdCJTkycSU3Rkl4JUU0JUMyNyVFMCVGQiU1RGglODJvJTBDa2glRTMlMUZaU3glRTglRTElREQlRUUlMDglOUIlOTclQ0ElQUYlQkUlRjIlQUMlQzIlOEIlMUMlRjRrJUUzQSUwMyVGNktPJUY5
YU4lRDAlMTclRThEbUolMTclRjYlRDclMUVqJUEyJTk1JUU3JUE4JTBEJTdFJTgxJUJGRCVERSVENk8lRjglMDYlMUUlM0ElRjAlREElRjElREQlQjQlRjIlOUElQTUlMDMlQzlmJUU4JTg3JUNCJUE0JUE3JUMzJUNGUCVGNSVEQSU5NSUzRSVGNlUlRkYlM0QlRUVtJUY2JTFFTlUlQ0RNaCVFOCVBQVklRTklQkYlRTYl
ODglRUIlOTQlN0UlQzklRDclQ0ElMEIlOTYlODBPJUEyJTdGJUFBJUI3YVolQkQlQTklQUUlN0MlMTklMDElMDczJUUzeCUyRiVFMSUyOSVGQTAlODYlQ0ZuJTg5JUJFJUFGJUQxJUMzLUMlMkZZJUMyJUQ3VCVDRCUwQmIlRDlsJUQ4JTE5QSVBMyVGMiUwQzUlMUIlQUElRTclODhpJUMyRyU4NyVDRSUxNCU4RSU5QSVC
RCUxNiVGMCVBMXUlODYlQzUlQTElOUJDSyVDOCU5RiVBOCVBQiVCOSVGQiUwN1QlNUUzVg!!
//&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&<<[UnmodifiableBlock.End]::Coder Dialog Data::>>*/
?>