<?
/*-- Project Introduce --*/


/**
 * What's this Class ?
 *
 * @author		alee
 * @access		public
 */
class Ext_JCUser_Authenticator extends JCAT_CommonAuthenticator
{	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	bool
	 */
	public function AuthorizePurview(JCAT_IIdentity $aID)
	{
		// 只能是 Ext_JCUser_Identity 
		if( !JCAT_Global::IsKindOf($aID,'Ext_JCUser_Identity') )
		{
			return false ;
		}
		
		foreach($this->arrPurviews as $nServiceId=>$arrPurviews)
		{
			foreach($arrPurviews as $sPurviewDomain=>$nPurview)
			{
				if( $aID->HasPurview($nPurview,$sPurviewDomain,$nServiceId) )
				{
					return true ;
				}
			}
		}
		
		return false ;
	}
	
	/**
	 * 设置权限
	 *
	 * @access	public
	 * @param	$nPurview					int
	 * @param	$sPurviewDomain=null		string
	 * @param	$nService=0					int
	 * @return	void
	 */
	public function AddPurview($nPurview,$sPurviewDomain=null,$nService=0)
	{
		$this->arrPurviews[$nService][$sPurviewDomain] = $nPurview ;
	}
	
	
	/**
	 * Description
	 * 
	 * @access	private
	 * @var		array
	 */
	private $arrPurviews = array() ;
}

?>