<?php

class Ext_JCUser_Identity extends JCAT_DBIdentity
{
	const ID_CLASS = 'W3BUser' ;
	
	/**
	 * what's this
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Ext_JCUser_Identity()
	{
		$this->JCAT_DBIdentity(new Ext_JCUser_Model(true),Ext_JCUser_Model::PROP_PURVIEWS) ;
	}
	
	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$nPurviewBit			int			权限位
	 * @param	$sPurviewDomain=null	string		指定权限域
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewDomain=null,$nServiceId=0)
	{
		return $this->GetModel()->HasPurview($nPurviewBit,$sPurviewDomain,$nServiceId) ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	string
	 */
	public function GetIdentityClass()
	{
		return self::ID_CLASS ;		
	}	
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	int
	 */
	public function GetUID()
	{
		$aModel = $this->GetModel() ;
		if(!$aModel)
		{
			return 0 ;
		}
		
		else 
		{
			return $aModel->GetId() ;
		}
	}

	
	/**
	 * Description
	 *
	 * @access	public
	 * @param	$sUsername
	 * @param	$sPassword
	 * @param	$nServiceId=0
	 * @static
	 * @return	Ext_JCUser_Identity
	 */
	static public function CreateUser($sUsername,$sPassword,$nServiceId=0)
	{
		$aUserID = new self() ;
		$aUser = $aUserID->GetModel() ;
		
		$sPassword = $aView->GetUICtrlExchangeData('Password') ;
		$sPassword = $aUserID->EncodePassword($sPassword) ;
		$aUser->Set('sPassword',$sPassword) ;
		$aUser->Set('sUsername',$sUsername) ;
		$aUser->Set('nServiceId',$nServiceId) ;
		
		return $aUser->Create()? $aUserID: null ;
	}
}

?>
