<?php

class Ext_JCUser_Login extends W3B_Controller
		implements JCAT_IHTTPPublicController
{

	/**
	 * 构造函数 
	 * 
	 * @access	public
	 * @param	$aParent	JCAT_IController	父控制器 
	 * @return	void
	 */
	public function Ext_JCUser_Login(JCAT_IController $aParent=null )
	{
		// 调用父类构造函数
		$this->JCAT_Controller(__CLASS__,$aParent) ;
	}

	/**
	 * 初始化文档、视图、子控制器 
	 * 
	 * @access	public
	 * @return	void
	 */
	public function Initialize()
	{
		// 消息队列
		$aMessageQueue = new JCAT_MessageQueue() ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_OK') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_BAD') ;
		JCAT_MessageDispatcher::RegisterMessageQueue($aMessageQueue,'MSGMVC_DEBUG') ;

		// 消息输出对象
		$aMessageQueue->AddPrinter(new JCAT_MessageHTMLPrinter()) ;

		$this->SetMessageQueue($aMessageQueue) ;
		
	}
	
	/**
	 * @see JCAT_IController::MainRun()
	 *
	 */
	public function MainRun ()
	{
		$aService = $this->GetService() ;
		
		// 视图: Ext_JCUser_ViewFormBaseInfo
		$aLoginView = new Ext_JCUser_LoginView($this) ;
		JCAT_ASSERT::ASSERT_INSTANCE($aLoginView,'JCAT_IView',JCAT_Language::Sentence('名为 %s 的视图未定义','Ext_JCUser_Login')) ;
		
		// 提交表单视图
		if( $aLoginView->IsSubmitingForm() ) 
		{			
			$aLoginView->SetDataFromSubmited() ;

			// 用户输入校验
			if( $aLoginView->VerifyData() )
			{
				// 数据
				$sUserName = $aLoginView->GetUICtrlExchangeData('User') ;
				$sPassword = $aLoginView->GetUICtrlExchangeData('Password') ;

				$aUser = new Ext_JCUser_Identity() ;
				if( $aUser->Login($sUserName,$sPassword,$aService->GetIdManager()) )
				{
					// 触发事件
					$aService->GetEventDispatcher()->Emit(
						Ext_JCUser::EVENT_LoginSuccess
						,array($aUser,$this)
						,Ext_JCUser::EVENT_NAMESPACE
					) ;
				
					$aLoginView->ShowForm(false) ;
				}
			}			
		}

		// 显示视图
		if( $this->GetParentController() )
		{
			$aLoginView->ShowView() ;
		}
		
		else 
		{	
			// 执行框架 控制器
			$aFrame = W3B_Controller::CreateController('Ext_JCHtmlFrame_Controller',$aService,array($this)) ;
			$aFrame->PutinView($aLoginView) ;
			$aFrame->MainRun() ;
		}
	}
	
}

?>
