<?php 
/**
 * ... ...
 * ... ...
 *
 */ 


/**
 * 数据库文档类 
 *
 * @access public
 */
class Ext_JCUser_Model
	extends JCAT_DBModel
{
	const PROP_PURVIEWS = 'aPurviews' ;
	
	const PROP_SERVICEID = 'nServiceId' ;
	
	static private $arrORMConf_Base = array(
		'hub' => array(
			'table' => 'Ext_JCUser'
			, 'primaryKey' => 'nUserId'
			, 'properties' => array(
				JCAT_DBIdentity::AUTH_USERNAME => 'sUserName'
				, JCAT_DBIdentity::AUTH_PASSWORD => 'sPassword'
				, JCAT_DBIdentity::TIME_ACTIVE => 'nActiveTime'
				, JCAT_DBIdentity::TIME_CREATE => 'nCreateTime'
				, JCAT_DBIdentity::TIME_LASTLOGIN => 'nLastLoginTime'
				, JCAT_DBIdentity::IP_LASTLOGIN => 'sLastLoginIP'
				, JCAT_DBIdentity::IP_ACTIVE => 'sActiveIP'
			)
		)
	) ;
	
	static private $arrORMConf_Full = array(
		
		'hasAndBelongsToMany' => array(
	
			array(
				'table' => 'Ext_JCUser_Purview'
				, 'bridgeTable' => 'Ext_JCUser_PurviewLink'
				, 'fkToBridge' => 'nUserId'
				, 'fkFromBridge' => 'nPurviewId'
				, 'property' => self::PROP_PURVIEWS
			)
			
		)
	) ;
	
	/**
	 * 构造函数 
	 *
	 * @access	public 
	 * @return	void
	 */
	public function Ext_JCUser_Model($bFull=false,JCAT_DB $aDB=null)
	{
		$this->JCAT_DBModel( self::CreateShareORM($bFull,$aDB) ) ;
		
		//$this->FindBy('nServiceId',$nServiceId) ;
		//$this->FindBy('nServiceId',$nServiceId) ;
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @static
	 * @return	void
	 */
	static public function CreateShareORM($bFull=false,JCAT_DB $aDB=null)
	{
		$sORMConfName = $bFull? 'full': 'base' ;
		$arrORMConf = self::$arrORMConf_Base ;
		if($bFull)
		{
			$arrORMConf = array_merge($arrORMConf,self::$arrORMConf_Full) ;
		}
		
		if( !isset(self::$arrShareORM[$sORMConfName]) )
		{
			self::$arrShareORM[$sORMConfName] = new JCAT_ORM($aDB) ;
			self::$arrShareORM[$sORMConfName]->InitFromConfig($arrORMConf) ;
		}

		return self::$arrShareORM[$sORMConfName] ;
	}

	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function AddPurview($nPurviewBit,$sPurviewDomain=null,$nServiceId=0,$nSince=0,$nExpir=0)
	{
		$aAllPurviews = $this->GetModel(self::PROP_PURVIEWS) ;
		JCAT_ASSERT::ASSERT_NOTNULL($aAllPurviews,JCAT_Language::SentenceEx('无法使用AddPurview(): 创建 %s 对象时，构造函数的参数 $bFull 必须为 true','Ext_JCUser',null,__CLASS__)) ;
		$aNewPurview = $aAllPurviews->CreateChildModel() ;
		
		$aNewPurview->Set('nServiceId',$nServiceId) ;
		$aNewPurview->Set('nSince',$nSince) ;
		$aNewPurview->Set('nExpir',$nExpir) ;
		
		// 载入 purview 子模型对象
		$aPurview = $aNewPurview->GetModel('belongsTo:Ext_JCUser_Purview') ;
		$aPurview->FindBy('nPurviewBit',$nPurviewBit) ;
		$aPurview->FindBy('sPurviewDomain',$sPurviewDomain) ;
		if( !$aPurview->Load() )
		{
			$aNewPurview->Set('nPurviewBit',$nPurviewBit) ;
			$aNewPurview->Set('sPurviewDomain',$sPurviewDomain) ;
		}
		
		$aAllPurviews->AddModel($aNewPurview) ;
		$this->SetChanged(true) ;
		
		try{
			return $this->Serialize() ;
		}
		catch(Exception $e)
		{
			return false ;
		}
	}
	
	/**
	 * Description
	 *
	 * @access	public
	 * @return	void
	 */
	public function RemovePurview($nPurviewBit,$sPurviewDomain=null,$nServiceId=0)
	{
		$aAllPurviews = $this->GetModel(self::PROP_PURVIEWS) ;
		JCAT_ASSERT::ASSERT_NOTNULL($aAllPurviews,JCAT_Language::SentenceEx('无法使用AddPurview(): 创建 %s 对象时，构造函数的参数 $bFull 必须为 true','Ext_JCUser',null,__CLASS__)) ;
		
		$aIter = $aAllPurviews->CreateModelIterator() ;
		for ( $aIter->First(); !$aIter->IsDone(); $aIter->Next() )
		{
			$aPurview = $aIter->Current() ;
			
			if( $aPurview->Get('nPurviewBit')==$nPurviewBit
					and $aPurview->Get('sPurviewDomain')==$sPurviewDomain
					and $aPurview->Get('nServiceId')==$nServiceId )
			{
				$aPurview->Delete() ;
				$aAllPurviews->RemoveModel($aPurview) ;
				
				return ;
			}
		}
	}

	/**
	 * 检查权限
	 * 
	 * @access	public
	 * @param	$nPurviewBit			int			权限位
	 * @param	$sPurviewDomain=null	string		指定权限域
	 * @return	bool
	 */
	public function HasPurview($nPurviewBit,$sPurviewDomain=null,$nServiceId=0)
	{
		$aAllPurviews = $this->GetModel(self::PROP_PURVIEWS) ;
		JCAT_ASSERT::ASSERT_NOTNULL($aAllPurviews,JCAT_Language::SentenceEx('无法使用HasPurview(): 创建 %s 对象时，构造函数的参数 $bFull 必须为 true','Ext_JCUser',null,__CLASS__)) ;
		
		$aIterator = $aAllPurviews->CreateModelIterator() ;
		for ( $aIterator->First(); !$aIterator->IsDone(); $aIterator->Next() )
		{
			$aPurview = $aIterator->Current() ;
			
			// 检查权限所在的服务
			if( $aPurview->Get('nServiceId')!=0 and $aPurview->Get('nServiceId')!=$nServiceId )
			{
				continue ;
			}
			
			// 检查 权限域
			$sUserPurviewDomain = $aPurview->Get(JCAT_DBIdentity::PURVIEW_DOMAIN) ;
			if($sPurviewDomain and $sUserPurviewDomain!=$sPurviewDomain)
			{
				continue ;
			}
			
			$sUserPurviewBit = $aPurview->Get(JCAT_DBIdentity::PURVIEW_BIT) ;
			if( $nPurviewBit & $sUserPurviewBit )
			{
				return true ;
			}
		}
		
		return false ;
	}

	/**
	 * 检查用户名是否存在
	 *
	 * @access	public
	 * @param	$sUserName		string
	 * @return	bool
	 */
	static public function IsUserExists($sUserName)
	{
		$aDB = W3B_Platform::GetDefaultDB() ;
		return ($aDB->SelectOneRow('Ext_JCUser',"sUserName='{$sUserName}'")!==null) ;	
	}
	
	/**
	 * 检查用户名是否存在
	 *
	 * @access	public
	 * @param	$sEmail		string
	 * @return	bool
	 */
	static public function IsEmailExists($sEmail)
	{
		$aDB = JCAT_DB::CreateDefaultInstance() ;
		return ($aDB->SelectOneRow('Ext_JCUser',"sEmail ='{$sEmail}'")!==null) ;	
	}
	
	
	// 属性 ///////////////////////////////////

	/**
	 * Description
	 * 
	 * @access	private
	 * @static
	 * @var		array:JCAT_ORM
	 */
	static private $arrShareORM=array() ;
}


?>